/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio.compat;

import io.sniffy.nio.SniffySelector;
import io.sniffy.nio.compat.CompatSniffySocketChannel;
import io.sniffy.util.ExceptionUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class CompatSniffySelectorProvider
extends SelectorProvider {
    private final SelectorProvider delegate;

    public CompatSniffySelectorProvider(SelectorProvider delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void install() throws IOException {
        SelectorProvider delegate = SelectorProvider.provider();
        if (null != delegate && CompatSniffySelectorProvider.class.equals(delegate.getClass())) {
            return;
        }
        try {
            CompatSniffySelectorProvider.initializeUsingHolderSubClass(new CompatSniffySelectorProvider(delegate));
        }
        catch (IOException ex) {
            try {
                Class<?> clazz = Class.forName("java.nio.channels.spi.SelectorProvider");
                Field lockField = clazz.getDeclaredField("lock");
                lockField.setAccessible(true);
                Object lock = lockField.get(null);
                Field instanceField = clazz.getDeclaredField("provider");
                instanceField.setAccessible(true);
                Field modifiersField = CompatSniffySelectorProvider.getModifiersField();
                modifiersField.setAccessible(true);
                modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
                Object object = lock;
                synchronized (object) {
                    instanceField.set(null, new CompatSniffySelectorProvider(delegate));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to initialize SniffySelectorProvider", e);
            }
            catch (NoSuchFieldException e) {
                throw new IOException("Failed to initialize SniffySelectorProvider", e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Failed to initialize SniffySelectorProvider", e);
            }
        }
    }

    public static void uninstall() throws IOException {
    }

    private static void initializeUsingHolderSubClass(SelectorProvider provider) throws IOException {
        try {
            Class<?> holderClass = Class.forName("java.nio.channels.spi.SelectorProvider$Holder");
            Field instanceField = holderClass.getDeclaredField("INSTANCE");
            instanceField.setAccessible(true);
            Field modifiersField = CompatSniffySelectorProvider.getModifiersField();
            modifiersField.setAccessible(true);
            modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
            instanceField.set(null, provider);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to initialize SniffySelectorProvider", e);
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to initialize SniffySelectorProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to initialize SniffySelectorProvider", e);
        }
    }

    @IgnoreJRERequirement
    private static Field getModifiersField() throws NoSuchFieldException {
        try {
            return Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field field : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(field.getName())) continue;
                    return field;
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        return this.delegate.openDatagramChannel();
    }

    @Override
    @IgnoreJRERequirement
    public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
        return this.delegate.openDatagramChannel(family);
    }

    @Override
    public Pipe openPipe() throws IOException {
        return this.delegate.openPipe();
    }

    @Override
    public AbstractSelector openSelector() throws IOException {
        return new SniffySelector((SelectorProvider)this, this.delegate.openSelector());
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return this.delegate.openServerSocketChannel();
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return CompatSniffySelectorProvider.isPipeSocketChannel() ? this.delegate.openSocketChannel() : new CompatSniffySocketChannel(this, this.delegate.openSocketChannel());
    }

    private static boolean isPipeSocketChannel() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (null != stackTrace) {
            for (StackTraceElement ste : stackTrace) {
                if (!ste.getClassName().startsWith("sun.nio.ch.Pipe")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Channel inheritedChannel() throws IOException {
        return this.delegate.inheritedChannel();
    }

    @Override
    public SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
        try {
            return CompatSniffySelectorProvider.isPipeSocketChannel() ? (SocketChannel)CompatSniffySelectorProvider.method(SelectorProvider.class, "openSocketChannel", ProtocolFamily.class).invoke((Object)this.delegate, family) : new CompatSniffySocketChannel(this, (SocketChannel)CompatSniffySelectorProvider.method(SelectorProvider.class, "openSocketChannel", ProtocolFamily.class).invoke((Object)this.delegate, family));
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public ServerSocketChannel openServerSocketChannel(ProtocolFamily family) throws IOException {
        try {
            return (ServerSocketChannel)CompatSniffySelectorProvider.method(SelectorProvider.class, "openServerSocketChannel", ProtocolFamily.class).invoke((Object)this.delegate, family);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    private static Method method(Class<?> clazz, String methodName, Class<?> ... argumentTypes) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(methodName, argumentTypes);
        method.setAccessible(true);
        return method;
    }
}

