/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio.compat;

import io.sniffy.Sniffy;
import io.sniffy.SpyConfiguration;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.nio.compat.CompatSniffySocketChannelAdapter;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.socket.SniffySocket;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.JVMUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class CompatSniffySocketChannel
extends CompatSniffySocketChannelAdapter
implements SniffyNetworkConnection {
    private final int id = Sniffy.CONNECTION_ID_SEQUENCE.getAndIncrement();
    protected static volatile Integer defaultReceiveBufferSize;
    protected static volatile Integer defaultSendBufferSize;
    private volatile int potentiallyBufferedInputBytes = 0;
    private volatile int potentiallyBufferedOutputBytes = 0;
    private volatile long lastReadThreadId;
    private volatile long lastWriteThreadId;
    private volatile Integer connectionStatus;

    protected CompatSniffySocketChannel(SelectorProvider provider, SocketChannel delegate) {
        super(provider, delegate);
    }

    public void setConnectionStatus(Integer connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public InetSocketAddress getInetSocketAddress() {
        try {
            if (JVMUtil.getVersion() > 6) {
                return (InetSocketAddress)this.getRemoteAddress();
            }
            return (InetSocketAddress)this.socket().getRemoteSocketAddress();
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    private void sleepIfRequired(int bytesDown) throws ConnectException {
        int potentiallyBufferedInputBytes;
        this.lastReadThreadId = Thread.currentThread().getId();
        if (this.lastReadThreadId == this.lastWriteThreadId) {
            this.potentiallyBufferedOutputBytes = 0;
        }
        if ((potentiallyBufferedInputBytes = (this.potentiallyBufferedInputBytes -= bytesDown)) < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedInputBytes / 212992;
            this.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.potentiallyBufferedInputBytes = 212992;
        }
    }

    private void sleepIfRequiredForWrite(int bytesUp) throws ConnectException {
        int potentiallyBufferedOutputBytes;
        this.lastWriteThreadId = Thread.currentThread().getId();
        if (this.lastReadThreadId == this.lastWriteThreadId) {
            this.potentiallyBufferedInputBytes = 0;
        }
        if ((potentiallyBufferedOutputBytes = (this.potentiallyBufferedOutputBytes -= bytesUp)) < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedOutputBytes / 212992;
            this.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.potentiallyBufferedOutputBytes = 212992;
        }
    }

    @Deprecated
    public void logSocket(long millis) {
        this.logSocket(millis, 0, 0);
    }

    @Deprecated
    public void logSocket(long millis, int bytesDown, int bytesUp) {
        if (!SniffyConfiguration.INSTANCE.getSocketCaptureEnabled().booleanValue()) {
            return;
        }
        Sniffy.SniffyMode sniffyMode = Sniffy.getSniffyMode();
        if (sniffyMode.isEnabled() && null != this.getInetSocketAddress() && (millis > 0L || bytesDown > 0 || bytesUp > 0)) {
            Sniffy.logSocket((int)this.id, (InetSocketAddress)this.getInetSocketAddress(), (long)millis, (int)bytesDown, (int)bytesUp, (boolean)sniffyMode.isCaptureStackTraces());
        }
    }

    public void logTraffic(boolean sent, Protocol protocol, byte[] traffic, int off, int len) {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
            Sniffy.logTraffic((int)this.id, (InetSocketAddress)this.getInetSocketAddress(), (boolean)sent, (Protocol)protocol, (byte[])traffic, (int)off, (int)len, (boolean)effectiveSpyConfiguration.isCaptureStackTraces());
        }
    }

    public void checkConnectionAllowed() throws ConnectException {
        this.checkConnectionAllowed(0);
    }

    public void checkConnectionAllowed(int numberOfSleepCycles) throws ConnectException {
        this.checkConnectionAllowed(this.getInetSocketAddress(), numberOfSleepCycles);
    }

    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress) throws ConnectException {
        this.checkConnectionAllowed(inetSocketAddress, 1);
    }

    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress, int numberOfSleepCycles) throws ConnectException {
        if (!SniffyConfiguration.INSTANCE.getSocketFaultInjectionEnabled().booleanValue()) {
            return;
        }
        if (null != inetSocketAddress) {
            if (null == this.connectionStatus || ConnectionsRegistry.INSTANCE.isThreadLocal()) {
                this.connectionStatus = ConnectionsRegistry.INSTANCE.resolveSocketAddressStatus(inetSocketAddress, (SniffyNetworkConnection)this);
            }
            if (this.connectionStatus < 0) {
                if (numberOfSleepCycles > 0 && -1 != this.connectionStatus) {
                    try {
                        CompatSniffySocketChannel.sleepImpl(-1 * this.connectionStatus * numberOfSleepCycles);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw new ConnectException(String.format("Connection to %s refused by Sniffy", inetSocketAddress));
            }
            if (numberOfSleepCycles > 0 && this.connectionStatus > 0) {
                try {
                    CompatSniffySocketChannel.sleepImpl(this.connectionStatus * numberOfSleepCycles);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static void sleepImpl(int millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.checkConnectionAllowed((InetSocketAddress)remote, 1);
            boolean bl = super.connect(remote);
            return bl;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkConnectionAllowed(0);
        long start = System.currentTimeMillis();
        int bytesDown = 0;
        int position = dst.position();
        try {
            int n = bytesDown = super.read(dst);
            return n;
        }
        finally {
            this.sleepIfRequired(bytesDown);
            this.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
            SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
            if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
                dst.position(position);
                byte[] buff = new byte[bytesDown];
                dst.get(buff, 0, bytesDown);
                this.logTraffic(false, Protocol.TCP, buff, 0, buff.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.checkConnectionAllowed(0);
        long start = System.currentTimeMillis();
        long bytesDown = 0L;
        int[] positions = new int[length];
        int[] remainings = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = dsts[offset + i].position();
            remainings[i] = dsts[offset + i].remaining();
        }
        try {
            long l = bytesDown = super.read(dsts, offset, length);
            return l;
        }
        finally {
            while (bytesDown > Integer.MAX_VALUE) {
                this.sleepIfRequiredForWrite(Integer.MAX_VALUE);
                this.logSocket(System.currentTimeMillis() - start, Integer.MAX_VALUE, 0);
                bytesDown -= Integer.MAX_VALUE;
            }
            this.logSocket(System.currentTimeMillis() - start, (int)bytesDown, 0);
            SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
            if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
                for (int i = 0; i < length; ++i) {
                    dsts[offset + i].position(positions[i]);
                    byte[] buff = new byte[remainings[i]];
                    dsts[offset + i].get(buff, 0, remainings[i]);
                    this.logTraffic(false, Protocol.TCP, buff, 0, buff.length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkConnectionAllowed(0);
        long start = System.currentTimeMillis();
        int length = 0;
        int position = src.position();
        try {
            int n = length = super.write(src);
            return n;
        }
        finally {
            this.sleepIfRequiredForWrite(length);
            this.logSocket(System.currentTimeMillis() - start, 0, length);
            SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
            if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
                src.position(position);
                byte[] buff = new byte[length];
                src.get(buff, 0, length);
                this.logTraffic(true, Protocol.TCP, buff, 0, buff.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.checkConnectionAllowed(0);
        long start = System.currentTimeMillis();
        long bytesUp = 0L;
        int[] positions = new int[length];
        int[] remainings = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = srcs[offset + i].position();
            remainings[i] = srcs[offset + i].remaining();
        }
        try {
            long l = bytesUp = super.write(srcs, offset, length);
            return l;
        }
        finally {
            while (bytesUp > Integer.MAX_VALUE) {
                this.sleepIfRequiredForWrite(Integer.MAX_VALUE);
                this.logSocket(System.currentTimeMillis() - start, 0, Integer.MAX_VALUE);
                bytesUp -= Integer.MAX_VALUE;
            }
            this.sleepIfRequiredForWrite((int)bytesUp);
            this.logSocket(System.currentTimeMillis() - start, 0, (int)bytesUp);
            SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
            if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
                for (int i = 0; i < length; ++i) {
                    srcs[offset + i].position(positions[i]);
                    byte[] buff = new byte[remainings[i]];
                    srcs[offset + i].get(buff, 0, remainings[i]);
                    this.logTraffic(true, Protocol.TCP, buff, 0, buff.length);
                }
            }
        }
    }

    @Override
    public Socket socket() {
        try {
            return new SniffySocket(super.socket(), (SocketChannel)((Object)this), this.id, JVMUtil.getVersion() > 6 ? this.getInetSocketAddress() : null);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return super.socket();
        }
    }

    public int getPotentiallyBufferedInputBytes() {
        return this.potentiallyBufferedInputBytes;
    }

    public void setPotentiallyBufferedInputBytes(int potentiallyBufferedInputBytes) {
        this.potentiallyBufferedInputBytes = potentiallyBufferedInputBytes;
    }

    public int getPotentiallyBufferedOutputBytes() {
        return this.potentiallyBufferedOutputBytes;
    }

    public void setPotentiallyBufferedOutputBytes(int potentiallyBufferedOutputBytes) {
        this.potentiallyBufferedOutputBytes = potentiallyBufferedOutputBytes;
    }

    public long getLastReadThreadId() {
        return this.lastReadThreadId;
    }

    public void setLastReadThreadId(long lastReadThreadId) {
        this.lastReadThreadId = lastReadThreadId;
    }

    public long getLastWriteThreadId() {
        return this.lastWriteThreadId;
    }

    public void setLastWriteThreadId(long lastWriteThreadId) {
        this.lastWriteThreadId = lastWriteThreadId;
    }
}

