/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio.compat;

import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.ReflectionCopier;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.StackTraceExtractor;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import sun.nio.ch.SocketChannelDelegate;

public class CompatSniffySocketChannelAdapter
extends SocketChannelDelegate {
    private static final ReflectionCopier<SocketChannel> socketChannelFieldsCopier = new ReflectionCopier(SocketChannel.class, new String[]{"provider"});
    protected final SocketChannel delegate;

    protected CompatSniffySocketChannelAdapter(SelectorProvider provider, SocketChannel delegate) {
        super(provider, (Object)delegate);
        this.delegate = delegate;
    }

    private void copyToDelegate() {
        socketChannelFieldsCopier.copy((Object)this, (Object)this.delegate);
    }

    private void copyFromDelegate() {
        socketChannelFieldsCopier.copy((Object)this.delegate, (Object)this);
    }

    public FileDescriptor getFD() {
        if (StackTraceExtractor.hasClassAndMethodInStackTrace((String)"sun.nio.ch.FileChannelImpl", (String)"transferToDirectly")) {
            return null;
        }
        return super.getFD();
    }

    @IgnoreJRERequirement
    public SocketChannel bind(SocketAddress local) throws IOException {
        try {
            this.copyToDelegate();
            this.delegate.bind(local);
            CompatSniffySocketChannelAdapter compatSniffySocketChannelAdapter = this;
            return compatSniffySocketChannelAdapter;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @IgnoreJRERequirement
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        try {
            this.copyToDelegate();
            this.delegate.setOption((SocketOption)name, (Object)value);
            CompatSniffySocketChannelAdapter compatSniffySocketChannelAdapter = this;
            return compatSniffySocketChannelAdapter;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @IgnoreJRERequirement
    public SocketChannel shutdownInput() throws IOException {
        try {
            this.copyToDelegate();
            this.delegate.shutdownInput();
            CompatSniffySocketChannelAdapter compatSniffySocketChannelAdapter = this;
            return compatSniffySocketChannelAdapter;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @IgnoreJRERequirement
    public SocketChannel shutdownOutput() throws IOException {
        try {
            this.copyToDelegate();
            this.delegate.shutdownOutput();
            CompatSniffySocketChannelAdapter compatSniffySocketChannelAdapter = this;
            return compatSniffySocketChannelAdapter;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public Socket socket() {
        try {
            this.copyToDelegate();
            Socket socket = this.delegate.socket();
            return socket;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public boolean isConnected() {
        try {
            this.copyToDelegate();
            boolean bl = this.delegate.isConnected();
            return bl;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public boolean isConnectionPending() {
        try {
            this.copyToDelegate();
            boolean bl = this.delegate.isConnectionPending();
            return bl;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public boolean connect(SocketAddress remote) throws IOException {
        this.copyToDelegate();
        try {
            boolean bl = this.delegate.connect(remote);
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public boolean finishConnect() throws IOException {
        try {
            this.copyToDelegate();
            boolean bl = this.delegate.finishConnect();
            return bl;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @IgnoreJRERequirement
    public SocketAddress getRemoteAddress() throws IOException {
        try {
            this.copyToDelegate();
            SocketAddress socketAddress = this.delegate.getRemoteAddress();
            return socketAddress;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        try {
            this.copyToDelegate();
            int n = this.delegate.read(dst);
            return n;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        try {
            this.copyToDelegate();
            long l = this.delegate.read(dsts, offset, length);
            return l;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public int write(ByteBuffer src) throws IOException {
        try {
            this.copyToDelegate();
            int n = this.delegate.write(src);
            return n;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        try {
            this.copyToDelegate();
            long l = this.delegate.write(srcs, offset, length);
            return l;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public SocketAddress getLocalAddress() throws IOException {
        try {
            this.copyToDelegate();
            SocketAddress socketAddress = this.delegate.getLocalAddress();
            return socketAddress;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public void implCloseSelectableChannel() {
        try {
            this.copyToDelegate();
            ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implCloseSelectableChannel", Void.class);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    public void implConfigureBlocking(boolean block) {
        try {
            this.copyToDelegate();
            ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implConfigureBlocking", Boolean.TYPE, (Object)block, Void.class);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @IgnoreJRERequirement
    public <T> T getOption(SocketOption<T> name) throws IOException {
        try {
            this.copyToDelegate();
            T t = this.delegate.getOption(name);
            return t;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @IgnoreJRERequirement
    public Set<SocketOption<?>> supportedOptions() {
        try {
            this.copyToDelegate();
            Set<SocketOption<?>> set = this.delegate.supportedOptions();
            return set;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.copyFromDelegate();
        }
    }
}

