/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio.compat;

import io.sniffy.nio.compat.SniffyAsynchronousSocketChannel;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class SniffyAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private final AsynchronousChannelProvider delegate;

    public SniffyAsynchronousChannelProvider(AsynchronousChannelProvider delegate) {
        this.delegate = delegate;
    }

    public static void install() {
        AsynchronousChannelProvider delegate = AsynchronousChannelProvider.provider();
        if (null != delegate && SniffyAsynchronousChannelProvider.class.equals(delegate.getClass())) {
            return;
        }
        try {
            Class<?> holderClass = Class.forName("java.nio.channels.spi.AsynchronousChannelProvider$ProviderHolder");
            Field instanceField = holderClass.getDeclaredField("provider");
            instanceField.setAccessible(true);
            Field modifiersField = SniffyAsynchronousChannelProvider.getModifiersField();
            modifiersField.setAccessible(true);
            modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
            instanceField.set(null, new SniffyAsynchronousChannelProvider(delegate));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void uninstall() {
    }

    @IgnoreJRERequirement
    private static Field getModifiersField() throws NoSuchFieldException {
        try {
            return Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field field : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(field.getName())) continue;
                    return field;
                }
            }
            catch (ReflectiveOperationException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int nThreads, ThreadFactory threadFactory) throws IOException {
        return this.delegate.openAsynchronousChannelGroup(nThreads, threadFactory);
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executor, int initialSize) throws IOException {
        return this.delegate.openAsynchronousChannelGroup(executor, initialSize);
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return this.delegate.openAsynchronousServerSocketChannel(group);
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return new SniffyAsynchronousSocketChannel(this, this.delegate.openAsynchronousSocketChannel(group));
    }
}

