/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

public abstract class SocketChannelDelegate
extends SocketChannel
implements SelChImpl {
    private final SelChImpl delegate;
    private static final Method TRANSLATE_INTEREST_OPS_METHOD;
    private static final Method TRANSLATE_AND_SET_INTEREST_OPS_METHOD;
    private static final Method PARK_METHOD;
    private static final Method PARK_NANOS_METHOD;

    public SocketChannelDelegate(SelectorProvider provider, Object delegate) {
        super(provider);
        this.delegate = (SelChImpl)delegate;
    }

    @Override
    public FileDescriptor getFD() {
        return this.delegate.getFD();
    }

    @Override
    public int getFDVal() {
        return this.delegate.getFDVal();
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegate.translateAndUpdateReadyOps(ops, sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegate.translateAndSetReadyOps(ops, sk);
    }

    @Override
    public int translateInterestOps(int ops) {
        if (null != TRANSLATE_INTEREST_OPS_METHOD) {
            try {
                return (Integer)TRANSLATE_INTEREST_OPS_METHOD.invoke((Object)this.delegate, ops);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        if (null != TRANSLATE_AND_SET_INTEREST_OPS_METHOD) {
            try {
                TRANSLATE_AND_SET_INTEREST_OPS_METHOD.invoke((Object)this.delegate, ops, sk);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void kill() throws IOException {
        this.delegate.kill();
    }

    @Override
    public void park(int event, long nanos) throws IOException {
        if (null != PARK_NANOS_METHOD) {
            try {
                PARK_NANOS_METHOD.invoke((Object)this.delegate, event, nanos);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void park(int event) throws IOException {
        if (null != PARK_METHOD) {
            try {
                PARK_METHOD.invoke((Object)this.delegate, event);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Method parkNanosMethod;
        Method parkMethod;
        Method translateAndSetInterestOpsMethod;
        Method translateInterestOpsMethod;
        try {
            translateInterestOpsMethod = SelChImpl.class.getMethod("translateInterestOps", Integer.TYPE);
        }
        catch (Exception e) {
            translateInterestOpsMethod = null;
        }
        TRANSLATE_INTEREST_OPS_METHOD = translateInterestOpsMethod;
        try {
            translateAndSetInterestOpsMethod = SelChImpl.class.getMethod("translateAndSetInterestOps", Integer.TYPE, SelectionKeyImpl.class);
        }
        catch (Exception e) {
            translateAndSetInterestOpsMethod = null;
        }
        TRANSLATE_AND_SET_INTEREST_OPS_METHOD = translateAndSetInterestOpsMethod;
        try {
            parkMethod = SelChImpl.class.getMethod("park", Integer.TYPE);
        }
        catch (Exception e) {
            parkMethod = null;
        }
        PARK_METHOD = parkMethod;
        try {
            parkNanosMethod = SelChImpl.class.getMethod("park", Integer.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            parkNanosMethod = null;
        }
        PARK_NANOS_METHOD = parkNanosMethod;
    }
}

