/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.Sniffy;
import io.sniffy.SpyConfiguration;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.util.ExceptionUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SniffyAsynchronousSocketChannel
extends AsynchronousSocketChannel
implements SniffyNetworkConnection {
    private static final Polyglog LOG = PolyglogFactory.log(SniffyAsynchronousSocketChannel.class);
    private final AsynchronousSocketChannel delegate;
    private final int id = Sniffy.CONNECTION_ID_SEQUENCE.getAndIncrement();
    private volatile int potentiallyBufferedInputBytes = 0;
    private volatile int potentiallyBufferedOutputBytes = 0;
    private volatile long lastReadThreadId;
    private volatile long lastWriteThreadId;
    private volatile Integer connectionStatus;

    public SniffyAsynchronousSocketChannel(AsynchronousChannelProvider provider, AsynchronousSocketChannel delegate) {
        super(provider);
        this.delegate = delegate;
    }

    public void setConnectionStatus(Integer connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public InetSocketAddress getInetSocketAddress() {
        try {
            return (InetSocketAddress)this.delegate.getRemoteAddress();
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    private void sleepIfRequired(int bytesDown) throws ConnectException {
        int potentiallyBufferedInputBytes;
        this.lastReadThreadId = Thread.currentThread().getId();
        if (this.lastReadThreadId == this.lastWriteThreadId) {
            this.potentiallyBufferedOutputBytes = 0;
        }
        if ((potentiallyBufferedInputBytes = (this.potentiallyBufferedInputBytes -= bytesDown)) < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedInputBytes / 212992;
            this.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.potentiallyBufferedInputBytes = 212992;
        }
    }

    private void sleepIfRequiredForWrite(int bytesUp) throws ConnectException {
        int potentiallyBufferedOutputBytes;
        this.lastWriteThreadId = Thread.currentThread().getId();
        if (this.lastReadThreadId == this.lastWriteThreadId) {
            this.potentiallyBufferedInputBytes = 0;
        }
        if ((potentiallyBufferedOutputBytes = (this.potentiallyBufferedOutputBytes -= bytesUp)) < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedOutputBytes / 212992;
            this.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.potentiallyBufferedOutputBytes = 212992;
        }
    }

    private static void sleepImpl(int millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    @Deprecated
    public void logSocket(long millis) {
        this.logSocket(millis, 0, 0);
    }

    @Deprecated
    public void logSocket(long millis, int bytesDown, int bytesUp) {
        if (!SniffyConfiguration.INSTANCE.getSocketCaptureEnabled().booleanValue()) {
            return;
        }
        Sniffy.SniffyMode sniffyMode = Sniffy.getSniffyMode();
        if (sniffyMode.isEnabled() && null != this.getInetSocketAddress() && (millis > 0L || bytesDown > 0 || bytesUp > 0)) {
            Sniffy.logSocket((int)this.id, (InetSocketAddress)this.getInetSocketAddress(), (long)millis, (int)bytesDown, (int)bytesUp, (boolean)sniffyMode.isCaptureStackTraces());
        }
    }

    public void logTraffic(boolean sent, Protocol protocol, byte[] traffic, int off, int len) {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
            LOG.trace("SniffyAsynchronousSocketChannel.logTraffic() called; sent = " + sent + "; len = " + len + "; connectionId = " + this.id);
            Sniffy.logTraffic((int)this.id, (InetSocketAddress)this.getInetSocketAddress(), (boolean)sent, (Protocol)protocol, (byte[])traffic, (int)off, (int)len, (boolean)effectiveSpyConfiguration.isCaptureStackTraces());
        }
    }

    public void checkConnectionAllowed() throws ConnectException {
        this.checkConnectionAllowed(0);
    }

    public void checkConnectionAllowed(int numberOfSleepCycles) throws ConnectException {
        this.checkConnectionAllowed(this.getInetSocketAddress(), numberOfSleepCycles);
    }

    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress) throws ConnectException {
        this.checkConnectionAllowed(inetSocketAddress, 1);
    }

    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress, int numberOfSleepCycles) throws ConnectException {
        if (!SniffyConfiguration.INSTANCE.getSocketFaultInjectionEnabled().booleanValue()) {
            return;
        }
        if (null != inetSocketAddress) {
            if (null == this.connectionStatus || ConnectionsRegistry.INSTANCE.isThreadLocal()) {
                this.connectionStatus = ConnectionsRegistry.INSTANCE.resolveSocketAddressStatus(inetSocketAddress, (SniffyNetworkConnection)this);
            }
            if (this.connectionStatus < 0) {
                if (numberOfSleepCycles > 0 && -1 != this.connectionStatus) {
                    try {
                        SniffyAsynchronousSocketChannel.sleepImpl(-1 * this.connectionStatus * numberOfSleepCycles);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw new ConnectException(String.format("Connection to %s refused by Sniffy", inetSocketAddress));
            }
            if (numberOfSleepCycles > 0 && this.connectionStatus > 0) {
                try {
                    SniffyAsynchronousSocketChannel.sleepImpl(this.connectionStatus * numberOfSleepCycles);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static AsynchronousSocketChannel open(AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    public static AsynchronousSocketChannel open() throws IOException {
        return AsynchronousSocketChannel.open();
    }

    @Override
    public AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        return this.delegate.bind(local);
    }

    @Override
    public <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this.delegate.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public AsynchronousSocketChannel shutdownInput() throws IOException {
        return this.delegate.shutdownInput();
    }

    @Override
    public AsynchronousSocketChannel shutdownOutput() throws IOException {
        return this.delegate.shutdownOutput();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        this.delegate.connect(remote, attachment, handler);
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        long start = System.currentTimeMillis();
        try {
            this.checkConnectionAllowed(1);
            Future<Void> future = this.delegate.connect(remote);
            return future;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.read(dst, timeout, unit, attachment, handler);
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        final long start = System.currentTimeMillis();
        final Future<Integer> integerFuture = this.delegate.read(dst);
        return new Future<Integer>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return integerFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return integerFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return integerFuture.isDone();
            }

            @Override
            public Integer get() throws InterruptedException, ExecutionException {
                Integer bytesDown = (Integer)integerFuture.get();
                try {
                    SniffyAsynchronousSocketChannel.this.checkConnectionAllowed(0);
                    SniffyAsynchronousSocketChannel.this.sleepIfRequired(bytesDown);
                }
                catch (ConnectException e) {
                    throw new ExecutionException(new AsynchronousCloseException());
                }
                SniffyAsynchronousSocketChannel.this.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
                return bytesDown;
            }

            @Override
            public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Integer bytesDown = (Integer)integerFuture.get(timeout, unit);
                try {
                    SniffyAsynchronousSocketChannel.this.checkConnectionAllowed(0);
                    SniffyAsynchronousSocketChannel.this.sleepIfRequired(bytesDown);
                }
                catch (ConnectException e) {
                    throw new ExecutionException(new AsynchronousCloseException());
                }
                SniffyAsynchronousSocketChannel.this.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
                return bytesDown;
            }
        };
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.delegate.read(dsts, offset, length, timeout, unit, attachment, handler);
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.write(src, timeout, unit, attachment, handler);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        final long start = System.currentTimeMillis();
        final Future<Integer> integerFuture = this.delegate.write(src);
        return new Future<Integer>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return integerFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return integerFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return integerFuture.isDone();
            }

            @Override
            public Integer get() throws InterruptedException, ExecutionException {
                Integer bytesUp = (Integer)integerFuture.get();
                try {
                    SniffyAsynchronousSocketChannel.this.checkConnectionAllowed(0);
                    SniffyAsynchronousSocketChannel.this.sleepIfRequiredForWrite(bytesUp);
                }
                catch (ConnectException e) {
                    throw new ExecutionException(new AsynchronousCloseException());
                }
                SniffyAsynchronousSocketChannel.this.logSocket(System.currentTimeMillis() - start, 0, bytesUp);
                return bytesUp;
            }

            @Override
            public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Integer bytesUp = (Integer)integerFuture.get(timeout, unit);
                try {
                    SniffyAsynchronousSocketChannel.this.checkConnectionAllowed(0);
                    SniffyAsynchronousSocketChannel.this.sleepIfRequiredForWrite(bytesUp);
                }
                catch (ConnectException e) {
                    throw new ExecutionException(new AsynchronousCloseException());
                }
                SniffyAsynchronousSocketChannel.this.logSocket(System.currentTimeMillis() - start, 0, bytesUp);
                return bytesUp;
            }
        };
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.delegate.write(srcs, offset, length, timeout, unit, attachment, handler);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.delegate.getLocalAddress();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    public int getPotentiallyBufferedInputBytes() {
        return this.potentiallyBufferedInputBytes;
    }

    public void setPotentiallyBufferedInputBytes(int potentiallyBufferedInputBytes) {
        this.potentiallyBufferedInputBytes = potentiallyBufferedInputBytes;
    }

    public int getPotentiallyBufferedOutputBytes() {
        return this.potentiallyBufferedOutputBytes;
    }

    public void setPotentiallyBufferedOutputBytes(int potentiallyBufferedOutputBytes) {
        this.potentiallyBufferedOutputBytes = potentiallyBufferedOutputBytes;
    }

    public long getLastReadThreadId() {
        return this.lastReadThreadId;
    }

    public void setLastReadThreadId(long lastReadThreadId) {
        this.lastReadThreadId = lastReadThreadId;
    }

    public long getLastWriteThreadId() {
        return this.lastWriteThreadId;
    }

    public void setLastWriteThreadId(long lastWriteThreadId) {
        this.lastWriteThreadId = lastWriteThreadId;
    }
}

