/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

public class SniffyPipe
extends Pipe {
    private final SelectorProvider selectorProvider;
    private final Pipe delegate;

    public SniffyPipe(SelectorProvider selectorProvider, Pipe delegate) {
        this.selectorProvider = selectorProvider;
        this.delegate = delegate;
    }

    @Override
    public Pipe.SourceChannel source() {
        return new SniffySourceChannel(this.selectorProvider, this.delegate.source());
    }

    @Override
    public Pipe.SinkChannel sink() {
        return new SniffySinkChannel(this.selectorProvider, this.delegate.sink());
    }

    public static class SniffySinkChannel
    extends Pipe.SinkChannel
    implements SelChImpl {
        private final Pipe.SinkChannel delegate;
        private final SelChImpl selChImplDelegate;

        public SniffySinkChannel(SelectorProvider provider, Pipe.SinkChannel delegate) {
            super(provider);
            this.delegate = delegate;
            this.selChImplDelegate = (SelChImpl)((Object)delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void implCloseSelectableChannel() {
            try {
                Object delegateCloseLock;
                Object object = delegateCloseLock = ReflectionUtil.getField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closeLock");
                synchronized (object) {
                    ReflectionUtil.setField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closed", (Object)true);
                    ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implCloseSelectableChannel", Void.class);
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void implConfigureBlocking(boolean block) {
            try {
                Object delegateRegLock;
                Object object = delegateRegLock = ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"regLock");
                synchronized (object) {
                    ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implConfigureBlocking", Boolean.TYPE, (Object)block, Void.class);
                    if (!ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"nonBlocking", (Object)(!block ? 1 : 0))) {
                        ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"blocking", (Object)block);
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.delegate.write(srcs);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public FileDescriptor getFD() {
            return this.selChImplDelegate.getFD();
        }

        @Override
        public int getFDVal() {
            return this.selChImplDelegate.getFDVal();
        }

        @Override
        public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
            return this.selChImplDelegate.translateAndUpdateReadyOps(ops, ski);
        }

        @Override
        public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
            return this.selChImplDelegate.translateAndSetReadyOps(ops, ski);
        }

        @Override
        public void kill() throws IOException {
            this.selChImplDelegate.kill();
        }

        public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateAndSetInterestOps", Integer.TYPE, (Object)ops, SelectionKeyImpl.class, (Object)sk, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public int translateInterestOps(int ops) {
            try {
                return (Integer)ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateInterestOps", Integer.TYPE, (Object)ops, Integer.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public void park(int event, long nanos) throws IOException {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Long.TYPE, (Object)nanos, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.throwException((Throwable)e);
            }
        }

        @Override
        public void park(int event) throws IOException {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.throwException((Throwable)e);
            }
        }
    }

    public static class SniffySourceChannel
    extends Pipe.SourceChannel
    implements SelChImpl {
        private final Pipe.SourceChannel delegate;
        private final SelChImpl selChImplDelegate;

        public SniffySourceChannel(SelectorProvider provider, Pipe.SourceChannel delegate) {
            super(provider);
            this.delegate = delegate;
            this.selChImplDelegate = (SelChImpl)((Object)delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void implCloseSelectableChannel() {
            try {
                Object delegateCloseLock;
                Object object = delegateCloseLock = ReflectionUtil.getField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closeLock");
                synchronized (object) {
                    ReflectionUtil.setField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closed", (Object)true);
                    ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implCloseSelectableChannel", Void.class);
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void implConfigureBlocking(boolean block) {
            try {
                Object delegateRegLock;
                Object object = delegateRegLock = ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"regLock");
                synchronized (object) {
                    ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implConfigureBlocking", Boolean.TYPE, (Object)block, Void.class);
                    if (!ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"nonBlocking", (Object)(!block ? 1 : 0))) {
                        ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"blocking", (Object)block);
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.delegate.read(dsts);
        }

        @Override
        public FileDescriptor getFD() {
            return this.selChImplDelegate.getFD();
        }

        @Override
        public int getFDVal() {
            return this.selChImplDelegate.getFDVal();
        }

        @Override
        public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
            return this.selChImplDelegate.translateAndUpdateReadyOps(ops, ski);
        }

        @Override
        public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
            return this.selChImplDelegate.translateAndSetReadyOps(ops, ski);
        }

        @Override
        public void kill() throws IOException {
            this.selChImplDelegate.kill();
        }

        public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateAndSetInterestOps", Integer.TYPE, (Object)ops, SelectionKeyImpl.class, (Object)sk, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public int translateInterestOps(int ops) {
            try {
                return (Integer)ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateInterestOps", Integer.TYPE, (Object)ops, Integer.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.processException((Throwable)e);
            }
        }

        @Override
        public void park(int event, long nanos) throws IOException {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Long.TYPE, (Object)nanos, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.throwException((Throwable)e);
            }
        }

        @Override
        public void park(int event) throws IOException {
            try {
                ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Void.TYPE);
            }
            catch (Exception e) {
                throw ExceptionUtil.throwException((Throwable)e);
            }
        }
    }
}

