/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.nio.SniffySelector;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.JVMUtil;
import io.sniffy.util.ObjectWrapper;
import io.sniffy.util.ObjectWrapperFieldUpdater;
import io.sniffy.util.ReflectionUtil;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SniffySelectionKey
extends SelectionKey
implements ObjectWrapper<SelectionKey> {
    private final SelectionKey delegate;
    private final SniffySelector sniffySelector;
    private final SelectableChannel sniffyChannel;

    protected SniffySelectionKey(SelectionKey delegate, SniffySelector sniffySelector, SelectableChannel sniffyChannel) {
        this.delegate = delegate;
        if (null != delegate) {
            this.attach(delegate.attachment());
        }
        this.sniffySelector = sniffySelector;
        this.sniffyChannel = sniffyChannel;
    }

    public SelectionKey getDelegate() {
        return this.delegate;
    }

    @Override
    public SelectableChannel channel() {
        return this.sniffyChannel;
    }

    @Override
    public Selector selector() {
        return this.sniffySelector;
    }

    @Override
    public boolean isValid() {
        return this.delegate.isValid();
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public int interestOps() {
        return this.delegate.interestOps();
    }

    @Override
    public SelectionKey interestOps(int ops) {
        this.delegate.interestOps(ops);
        return this;
    }

    @Override
    public int readyOps() {
        return this.delegate.readyOps();
    }

    @Override
    public int interestOpsOr(int ops) {
        try {
            return (Integer)ReflectionUtil.invokeMethod(SelectionKey.class, (Object)this.delegate, (String)"interestOpsOr", Integer.TYPE, (Object)ops, Integer.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public int interestOpsAnd(int ops) {
        try {
            return (Integer)ReflectionUtil.invokeMethod(SelectionKey.class, (Object)this.delegate, (String)"interestOpsAnd", Integer.TYPE, (Object)ops, Integer.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    static {
        if (JVMUtil.getVersion() < 14 && !Boolean.getBoolean("io.sniffy.forceJava14Compatibility")) {
            try {
                AtomicReferenceFieldUpdater defaultFieldUpdater = (AtomicReferenceFieldUpdater)ReflectionUtil.getField(SelectionKey.class, null, (String)"attachmentUpdater");
                ObjectWrapperFieldUpdater attachmentFieldUpdater = new ObjectWrapperFieldUpdater(defaultFieldUpdater);
                ReflectionUtil.setField(SelectionKey.class, null, (String)"attachmentUpdater", (Object)attachmentFieldUpdater);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

