/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.nio.SelectableChannelWrapper;
import io.sniffy.nio.SniffySelectionKey;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.JVMUtil;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.SetWrapper;
import io.sniffy.util.WrapperFactory;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;

public class SniffySelector
extends AbstractSelector {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySelector.class);
    private final AbstractSelector delegate;
    private final Map<AbstractSelectableChannel, AbstractSelectableChannel> channelToSniffyChannelMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<SelectionKey, SniffySelectionKey> sniffySelectionKeyCache = new WeakHashMap<SelectionKey, SniffySelectionKey>();

    public SniffySelector(SelectorProvider provider, AbstractSelector delegate) {
        super(provider);
        this.delegate = delegate;
        LOG.trace("Created new SniffySelector(" + provider + ", " + delegate + ") = " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SniffySelectionKey wrap(SelectionKey delegate, SniffySelector sniffySelector, SelectableChannel sniffyChannel) {
        SniffySelectionKey sniffySelectionKey = this.sniffySelectionKeyCache.get(delegate);
        if (null == sniffySelectionKey) {
            Map<SelectionKey, SniffySelectionKey> map = this.sniffySelectionKeyCache;
            synchronized (map) {
                sniffySelectionKey = this.sniffySelectionKeyCache.get(delegate);
                if (null == sniffySelectionKey) {
                    sniffySelectionKey = new SniffySelectionKey(delegate, sniffySelector, sniffyChannel);
                    this.sniffySelectionKeyCache.put(delegate, sniffySelectionKey);
                }
            }
        }
        return sniffySelectionKey;
    }

    @Override
    protected void implCloseSelector() throws IOException {
        try {
            ReflectionUtil.setField(AbstractSelector.class, (Object)this.delegate, (String)"closed", (Object)true);
            ReflectionUtil.invokeMethod(AbstractSelector.class, (Object)this.delegate, (String)"implCloseSelector", Void.class);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    private Set<SelectionKey> wrapSelectionKeys(Set<SelectionKey> delegates) {
        if (null == delegates) {
            return null;
        }
        if (delegates.isEmpty()) {
            return Collections.emptySet();
        }
        return new SetWrapper(delegates, (WrapperFactory)new WrapperFactory<SelectionKey, SniffySelectionKey>(){

            public SniffySelectionKey wrap(SelectionKey delegate) {
                return SniffySelector.this.wrap(delegate, SniffySelector.this, (SelectableChannel)SniffySelector.this.channelToSniffyChannelMap.get(delegate.channel()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        try {
            Object keyLock;
            AbstractSelectableChannel chDelegate = ch;
            if (ch instanceof SelectableChannelWrapper) {
                chDelegate = ((SelectableChannelWrapper)((Object)ch)).getDelegate();
                this.channelToSniffyChannelMap.put(chDelegate, ch);
            }
            SelectionKey selectionKeyDelegate = (SelectionKey)ReflectionUtil.invokeMethod(AbstractSelector.class, (Object)this.delegate, (String)"register", AbstractSelectableChannel.class, (Object)chDelegate, Integer.TYPE, (Object)ops, Object.class, (Object)att, SelectionKey.class);
            Object object = keyLock = ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)chDelegate, (String)"keyLock");
            synchronized (object) {
                ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)chDelegate, (String)"addKey", SelectionKey.class, (Object)selectionKeyDelegate, Void.class);
            }
            return this.wrap(selectionKeyDelegate, this, ch);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.wrapSelectionKeys(this.delegate.keys());
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.wrapSelectionKeys(this.delegate.selectedKeys());
    }

    @Override
    public int selectNow() throws IOException {
        try {
            int n = this.delegate.selectNow();
            return n;
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectionKeysFromDelegate() {
        HashMap<AbstractSelectableChannel, AbstractSelectableChannel> channelToSniffyChannelMap;
        if (JVMUtil.getVersion() < 14 && !Boolean.getBoolean("io.sniffy.forceJava14Compatibility")) {
            return;
        }
        Map<AbstractSelectableChannel, AbstractSelectableChannel> map = this.channelToSniffyChannelMap;
        synchronized (map) {
            channelToSniffyChannelMap = new HashMap<AbstractSelectableChannel, AbstractSelectableChannel>(this.channelToSniffyChannelMap);
        }
        for (Map.Entry entry : channelToSniffyChannelMap.entrySet()) {
            AbstractSelectableChannel sniffyChannel = (AbstractSelectableChannel)entry.getValue();
            if (!(sniffyChannel instanceof SelectableChannelWrapper)) continue;
            Object delegate = ((SelectableChannelWrapper)((Object)sniffyChannel)).getDelegate();
            try {
                Object keyLock = ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)sniffyChannel, (String)"keyLock");
                Object delegateKeyLock = ReflectionUtil.getField(AbstractSelectableChannel.class, delegate, (String)"keyLock");
                Object object = keyLock;
                synchronized (object) {
                    Object object2 = delegateKeyLock;
                    synchronized (object2) {
                        SelectionKey[] delegateKeys = (SelectionKey[])ReflectionUtil.getField(AbstractSelectableChannel.class, delegate, (String)"keys");
                        ArrayList<SniffySelectionKey> sniffyKeys = new ArrayList<SniffySelectionKey>(delegateKeys.length);
                        for (SelectionKey delegateKey : delegateKeys) {
                            sniffyKeys.add(null == delegateKey ? null : this.wrap(delegateKey, this, sniffyChannel));
                        }
                        ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)sniffyChannel, (String)"keys", (Object)sniffyKeys.toArray(new SelectionKey[0]));
                        ReflectionUtil.setField(AbstractSelectableChannel.class, delegate, (String)"keyCount", (Object)ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)sniffyChannel, (String)"keyCount"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long timeout) throws IOException {
        try {
            int n = this.delegate.select(timeout);
            return n;
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    @Override
    public int select() throws IOException {
        try {
            int n = this.delegate.select();
            return n;
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    @Override
    public Selector wakeup() {
        this.delegate.wakeup();
        return this;
    }

    @Override
    public int select(Consumer<SelectionKey> action, long timeout) throws IOException {
        try {
            int n = (Integer)ReflectionUtil.invokeMethod(Selector.class, (Object)this.delegate, (String)"select", Consumer.class, (Object)new SelectionKeyConsumerWrapper(action), Long.TYPE, (Object)timeout, Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    @Override
    public int select(Consumer<SelectionKey> action) throws IOException {
        try {
            int n = (Integer)ReflectionUtil.invokeMethod(Selector.class, (Object)this.delegate, (String)"select", Consumer.class, (Object)new SelectionKeyConsumerWrapper(action), Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    @Override
    public int selectNow(Consumer<SelectionKey> action) throws IOException {
        try {
            int n = (Integer)ReflectionUtil.invokeMethod(Selector.class, (Object)this.delegate, (String)"selectNow", Consumer.class, (Object)new SelectionKeyConsumerWrapper(action), Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
        finally {
            this.updateSelectionKeysFromDelegate();
        }
    }

    private class SelectionKeyConsumerWrapper
    implements Consumer<SelectionKey> {
        private final Consumer<SelectionKey> delegate;
        private final AbstractSelectableChannel sniffyChannel;

        public SelectionKeyConsumerWrapper(Consumer<SelectionKey> delegate) {
            this(delegate, null);
        }

        public SelectionKeyConsumerWrapper(Consumer<SelectionKey> delegate, AbstractSelectableChannel sniffyChannel) {
            this.delegate = delegate;
            this.sniffyChannel = sniffyChannel;
        }

        @Override
        public void accept(SelectionKey selectionKey) {
            this.delegate.accept(SniffySelector.this.wrap(selectionKey, SniffySelector.this, this.sniffyChannel));
        }
    }
}

