/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.nio.SniffyDatagramChannelAdapter;
import io.sniffy.nio.SniffyPipe;
import io.sniffy.nio.SniffySelector;
import io.sniffy.nio.SniffyServerSocketChannel;
import io.sniffy.nio.SniffySocketChannel;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.OSUtil;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.StackTraceExtractor;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class SniffySelectorProvider
extends SelectorProvider {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySelectorProvider.class);
    private static volatile SelectorProvider previousSelectorProvider;
    private final SelectorProvider delegate;

    public SniffySelectorProvider(SelectorProvider delegate) {
        this.delegate = delegate;
    }

    public static synchronized boolean install() {
        SelectorProvider delegate = SelectorProvider.provider();
        LOG.info("Original SelectorProvider was " + delegate);
        if (null == delegate) {
            return false;
        }
        if (null == previousSelectorProvider && !SniffySelectorProvider.class.equals(delegate.getClass())) {
            previousSelectorProvider = delegate;
        }
        if (SniffySelectorProvider.class.equals(delegate.getClass())) {
            return true;
        }
        SniffySelectorProvider sniffySelectorProvider = new SniffySelectorProvider(delegate);
        LOG.info("Setting SelectorProvider to " + sniffySelectorProvider);
        if (ReflectionUtil.setField((String)"java.nio.channels.spi.SelectorProvider$Holder", null, (String)"INSTANCE", (Object)sniffySelectorProvider)) {
            return true;
        }
        return ReflectionUtil.setField(SelectorProvider.class, null, (String)"provider", (Object)sniffySelectorProvider, (String)"lock");
    }

    public static boolean uninstall() {
        LOG.info("Restoring original SelectorProvider " + previousSelectorProvider);
        if (null == previousSelectorProvider) {
            return false;
        }
        if (ReflectionUtil.setField((String)"java.nio.channels.spi.SelectorProvider$Holder", null, (String)"INSTANCE", (Object)previousSelectorProvider)) {
            return true;
        }
        return ReflectionUtil.setField(SelectorProvider.class, null, (String)"provider", (Object)previousSelectorProvider, (String)"lock");
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        return new SniffyDatagramChannelAdapter(this, this.delegate.openDatagramChannel());
    }

    @Override
    @IgnoreJRERequirement
    public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
        return new SniffyDatagramChannelAdapter(this, this.delegate.openDatagramChannel(family));
    }

    @Override
    public Pipe openPipe() throws IOException {
        return OSUtil.isWindows() && StackTraceExtractor.hasClassAndMethodInStackTrace((String)"io.sniffy.nio.SniffySelectorProvider", (String)"openSelector") ? this.delegate.openPipe() : new SniffyPipe(this, this.delegate.openPipe());
    }

    @Override
    public AbstractSelector openSelector() throws IOException {
        return new SniffySelector(this, this.delegate.openSelector());
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return OSUtil.isWindows() && StackTraceExtractor.hasClassInStackTrace((String)"sun.nio.ch.Pipe") ? this.delegate.openServerSocketChannel() : new SniffyServerSocketChannel(this, this.delegate.openServerSocketChannel());
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return OSUtil.isWindows() && StackTraceExtractor.hasClassInStackTrace((String)"sun.nio.ch.Pipe") ? this.delegate.openSocketChannel() : new SniffySocketChannel(this, this.delegate.openSocketChannel());
    }

    @Override
    public Channel inheritedChannel() throws IOException {
        Channel channel = this.delegate.inheritedChannel();
        if (channel instanceof SocketChannel) {
            return new SniffySocketChannel(this, (SocketChannel)channel);
        }
        if (channel instanceof ServerSocketChannel) {
            return new SniffyServerSocketChannel(this, (ServerSocketChannel)channel);
        }
        if (channel instanceof DatagramChannel) {
            return new SniffyDatagramChannelAdapter(this, (DatagramChannel)channel);
        }
        return channel;
    }

    @Override
    public SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
        try {
            return OSUtil.isWindows() && StackTraceExtractor.hasClassInStackTrace((String)"sun.nio.ch.Pipe") ? (SocketChannel)ReflectionUtil.invokeMethod(SelectorProvider.class, (Object)this.delegate, (String)"openSocketChannel", ProtocolFamily.class, (Object)family, SocketChannel.class) : new SniffySocketChannel(this, (SocketChannel)ReflectionUtil.invokeMethod(SelectorProvider.class, (Object)this.delegate, (String)"openSocketChannel", ProtocolFamily.class, (Object)family, SocketChannel.class));
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public ServerSocketChannel openServerSocketChannel(ProtocolFamily family) throws IOException {
        try {
            return (ServerSocketChannel)ReflectionUtil.invokeMethod(SelectorProvider.class, (Object)this.delegate, (String)"openServerSocketChannel", ProtocolFamily.class, (Object)family, ServerSocketChannel.class);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }
}

