/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.nio;

import io.sniffy.nio.SelectableChannelWrapper;
import io.sniffy.nio.SniffySocketChannelAdapter;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.OSUtil;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.StackTraceExtractor;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

public class SniffyServerSocketChannel
extends ServerSocketChannel
implements SelChImpl,
SelectableChannelWrapper<ServerSocketChannel> {
    private final ServerSocketChannel delegate;
    private final SelChImpl selChImplDelegate;

    public SniffyServerSocketChannel(SelectorProvider provider, ServerSocketChannel delegate) {
        super(provider);
        this.delegate = delegate;
        this.selChImplDelegate = (SelChImpl)((Object)delegate);
    }

    @Override
    public ServerSocketChannel getDelegate() {
        return this.delegate;
    }

    @Override
    @IgnoreJRERequirement
    public ServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        this.delegate.bind(local, backlog);
        return this;
    }

    @Override
    @IgnoreJRERequirement
    public <T> ServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.delegate.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public ServerSocket socket() {
        return this.delegate.socket();
    }

    @Override
    public SocketChannel accept() throws IOException {
        return OSUtil.isWindows() && StackTraceExtractor.hasClassInStackTrace((String)"sun.nio.ch.Pipe") ? this.delegate.accept() : new SniffySocketChannelAdapter(this.provider(), this.delegate.accept());
    }

    @Override
    @IgnoreJRERequirement
    public SocketAddress getLocalAddress() throws IOException {
        return this.delegate.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() {
        try {
            Object delegateCloseLock;
            Object object = delegateCloseLock = ReflectionUtil.getField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closeLock");
            synchronized (object) {
                ReflectionUtil.setField(AbstractInterruptibleChannel.class, (Object)this.delegate, (String)"closed", (Object)true);
                ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implCloseSelectableChannel", Void.class);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implConfigureBlocking(boolean block) {
        try {
            Object delegateRegLock;
            Object object = delegateRegLock = ReflectionUtil.getField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"regLock");
            synchronized (object) {
                ReflectionUtil.invokeMethod(AbstractSelectableChannel.class, (Object)this.delegate, (String)"implConfigureBlocking", Boolean.TYPE, (Object)block, Void.class);
                if (!ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"nonBlocking", (Object)(!block ? 1 : 0))) {
                    ReflectionUtil.setField(AbstractSelectableChannel.class, (Object)this.delegate, (String)"blocking", (Object)block);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    @IgnoreJRERequirement
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    @IgnoreJRERequirement
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    @Override
    public FileDescriptor getFD() {
        return this.selChImplDelegate.getFD();
    }

    @Override
    public int getFDVal() {
        return this.selChImplDelegate.getFDVal();
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
        return this.selChImplDelegate.translateAndUpdateReadyOps(ops, ski);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
        return this.selChImplDelegate.translateAndSetReadyOps(ops, ski);
    }

    @Override
    public void kill() throws IOException {
        this.selChImplDelegate.kill();
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        try {
            ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateAndSetInterestOps", Integer.TYPE, (Object)ops, SelectionKeyImpl.class, (Object)sk, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public int translateInterestOps(int ops) {
        try {
            return (Integer)ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"translateInterestOps", Integer.TYPE, (Object)ops, Integer.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException((Throwable)e);
        }
    }

    @Override
    public void park(int event, long nanos) throws IOException {
        try {
            ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Long.TYPE, (Object)nanos, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public void park(int event) throws IOException {
        try {
            ReflectionUtil.invokeMethod(SelChImpl.class, (Object)this.selChImplDelegate, (String)"park", Integer.TYPE, (Object)event, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }
}

