/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.tls;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.tls.SniffySSLSocketFactory;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.ReflectionUtil;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SniffySSLContextSpi
extends SSLContextSpi {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySSLContextSpi.class);
    private final SSLContextSpi delegate;

    public SniffySSLContextSpi(SSLContextSpi delegate) {
        this.delegate = delegate;
        LOG.trace("Created SniffySSLContextSpi(" + delegate + ")");
    }

    @Override
    public void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        try {
            ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineInit", KeyManager[].class, (Object)km, TrustManager[].class, (Object)tm, SecureRandom.class, (Object)sr, Void.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLSocketFactory engineGetSocketFactory() {
        try {
            return new SniffySSLSocketFactory((SSLSocketFactory)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetSocketFactory", SSLSocketFactory.class));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLServerSocketFactory engineGetServerSocketFactory() {
        try {
            return (SSLServerSocketFactory)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetServerSocketFactory", SSLServerSocketFactory.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLEngine engineCreateSSLEngine() {
        try {
            return (SSLEngine)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineCreateSSLEngine", SSLEngine.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLEngine engineCreateSSLEngine(String host, int port) {
        try {
            return (SSLEngine)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineCreateSSLEngine", String.class, (Object)host, Integer.TYPE, (Object)port, SSLEngine.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLSessionContext engineGetServerSessionContext() {
        try {
            return (SSLSessionContext)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetServerSessionContext", SSLSessionContext.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLSessionContext engineGetClientSessionContext() {
        try {
            return (SSLSessionContext)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetClientSessionContext", SSLSessionContext.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLParameters engineGetDefaultSSLParameters() {
        try {
            return (SSLParameters)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetDefaultSSLParameters", SSLParameters.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public SSLParameters engineGetSupportedSSLParameters() {
        try {
            return (SSLParameters)ReflectionUtil.invokeMethod(SSLContextSpi.class, (Object)this.delegate, (String)"engineGetSupportedSSLParameters", SSLParameters.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw ExceptionUtil.throwException((Throwable)e);
        }
    }
}

