/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.tls;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.tls.SniffySSLContextSpiProviderService;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.StackTraceExtractor;
import java.security.Provider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SniffySSLContextSpiProvider
extends Provider {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySSLContextSpiProvider.class);
    private final Provider originalProvider;

    public SniffySSLContextSpiProvider(Provider delegate) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        this(delegate, delegate.getName(), delegate.getVersion(), delegate.getInfo());
    }

    public SniffySSLContextSpiProvider(Provider delegate, String providerName, double providerVersion, String providerInfo) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        super(providerName, providerVersion, providerInfo);
        LOG.trace("Created SniffySSLContextSpiProvider(" + delegate + ", " + providerName + ", " + providerVersion + ", " + providerInfo + ")");
        this.originalProvider = delegate;
        for (Provider.Service service : delegate.getServices()) {
            this.putServiceIfAbsent(new SniffySSLContextSpiProviderService(this, service.getType(), service.getAlgorithm(), service.getClassName(), SniffySSLContextSpiProvider.extractAliases(service), SniffySSLContextSpiProvider.extractAttributes(service), service));
        }
    }

    @Override
    public String getName() {
        String providerName = super.getName();
        if ("Sniffy-SunJSSE".equals(providerName) && StackTraceExtractor.hasClassAndMethodInStackTrace((String)"sun.security.ssl.SSLContextImpl", (String)"getTrustManagers")) {
            LOG.trace("Mocking SunJSSE provider name since Sniffy was called from sun.security.ssl.SSLContextImpl.getTrustManagers()");
            providerName = "SunJSSE";
        }
        return providerName;
    }

    private void putServiceIfAbsent(Provider.Service service) {
        if (null == this.getService(service.getAlgorithm(), service.getType())) {
            this.putService(service);
        }
    }

    public static List<String> extractAliases(Provider.Service service) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return (List)ReflectionUtil.getField(Provider.Service.class, (Object)service, (String)"aliases");
    }

    public static Map<String, String> extractAttributes(Provider.Service service) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        HashMap<String, String> resultAttributes = new HashMap<String, String>();
        Map attributes = (Map)ReflectionUtil.getField(Provider.Service.class, (Object)service, (String)"attributes");
        for (Map.Entry entry : attributes.entrySet()) {
            String key = (String)ReflectionUtil.getField((String)"java.security.Provider$UString", entry.getKey(), (String)"string");
            String value = (String)entry.getValue();
            resultAttributes.put(key, value);
        }
        return resultAttributes;
    }

    public Provider getOriginalProvider() {
        return this.originalProvider;
    }
}

