/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.tls;

import io.sniffy.Sniffy;
import io.sniffy.SpyConfiguration;
import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.SnifferInputStream;
import io.sniffy.socket.SnifferOutputStream;
import io.sniffy.socket.TrafficCapturingNetworkConnection;
import io.sniffy.tls.SSLSocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLSocket;

public class SniffySSLSocket
extends SSLSocketAdapter
implements TrafficCapturingNetworkConnection {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySSLSocket.class);
    private final SocketChannel socketChannel;
    private InetSocketAddress address;
    private final int id = Sniffy.CONNECTION_ID_SEQUENCE.getAndIncrement();

    public void logTraffic(boolean sent, Protocol protocol, byte[] traffic, int off, int len) {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
            LOG.trace("SniffySSLSocket.logTraffic() called; sent = " + sent + "; len = " + len + "; connectionId = " + this.id);
            Sniffy.logDecryptedTraffic((int)this.id, (InetSocketAddress)this.address, (boolean)sent, (Protocol)protocol, (byte[])traffic, (int)off, (int)len, (boolean)effectiveSpyConfiguration.isCaptureStackTraces());
        }
    }

    public SniffySSLSocket(Socket delegate, InetSocketAddress address) {
        this((SSLSocket)delegate, address);
    }

    public SniffySSLSocket(SSLSocket delegate, InetSocketAddress address) {
        super(delegate);
        LOG.trace("Created SniffySSLSocket for delegate " + delegate + " and address " + address + "; id = " + this.id);
        this.socketChannel = null;
        this.address = null == address ? (InetSocketAddress)delegate.getRemoteSocketAddress() : address;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new SnifferInputStream((TrafficCapturingNetworkConnection)this, super.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SnifferOutputStream((TrafficCapturingNetworkConnection)this, super.getOutputStream());
    }
}

