/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.tls;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.tls.SniffySSLContext;
import io.sniffy.tls.SniffySSLContextSpiProvider;
import io.sniffy.tls.SniffySSLSocketFactory;
import io.sniffy.util.JVMUtil;
import io.sniffy.util.ReflectionUtil;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSocketFactory;

public class SniffySecurityUtil {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySecurityUtil.class);
    public static final String SSLCONTEXT = "SSLContext";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapJsseProvidersWithSniffy() throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException, NoSuchAlgorithmException {
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            Provider.Service defaultSniffySSLContextSpiProviderService;
            Object[] originalSecurityProviders = Security.getProviders();
            LOG.info("Original security providers are " + Arrays.toString(originalSecurityProviders));
            Provider firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = null;
            int j = 0;
            for (int i = 0; i < originalSecurityProviders.length; ++i) {
                Object originalSecurityProvider = originalSecurityProviders[i];
                if (originalSecurityProvider instanceof SniffySSLContextSpiProvider) continue;
                boolean hasSSLContextService = false;
                boolean hasDefaultSSLContextService = false;
                for (Provider.Service service : ((Provider)originalSecurityProvider).getServices()) {
                    if (!SSLCONTEXT.equals(service.getType())) continue;
                    hasSSLContextService = true;
                    if (!"Default".equalsIgnoreCase(service.getAlgorithm())) continue;
                    hasDefaultSSLContextService = true;
                    break;
                }
                if (!hasSSLContextService) continue;
                String originalProviderName = ((Provider)originalSecurityProvider).getName();
                SniffySSLContextSpiProvider sniffySSLContextSpiProvider = new SniffySSLContextSpiProvider((Provider)originalSecurityProvider, "Sniffy-" + originalProviderName, 3.0, "SniffySSLContextProvider");
                LOG.info("Original provider " + originalProviderName + " provides SSLContextSPI service - wrapped with " + sniffySSLContextSpiProvider);
                if (hasDefaultSSLContextService && null == firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi) {
                    firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = sniffySSLContextSpiProvider;
                }
                Security.removeProvider(originalProviderName);
                Security.insertProviderAt(new SniffySSLContextSpiProvider((Provider)originalSecurityProvider), i + j + 1);
                Security.insertProviderAt(sniffySSLContextSpiProvider, i + j + 1);
                ++j;
            }
            if (null != firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi && null != (defaultSniffySSLContextSpiProviderService = firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi.getService(SSLCONTEXT, "Default"))) {
                SSLSocketFactory originalSSLSocketFactory;
                LOG.info("Identified default SSLContext service provider - " + firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi + " with service " + defaultSniffySSLContextSpiProviderService);
                SniffySSLContext defaultSniffySSLContext = new SniffySSLContext((SSLContextSpi)defaultSniffySSLContextSpiProviderService.newInstance(null), firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi, "Default");
                LOG.info("Setting SSLContext.default to " + defaultSniffySSLContext);
                SSLContext.setDefault(defaultSniffySSLContext);
                if (JVMUtil.getVersion() >= 13) {
                    LOG.info("Java 13+ detected - attempt to update javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder");
                    originalSSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class);
                    if (null != originalSSLSocketFactory) {
                        SniffySSLSocketFactory sniffySSLSocketFactory = new SniffySSLSocketFactory(originalSSLSocketFactory);
                        LOG.info("Replacing " + originalSSLSocketFactory + " with " + sniffySSLSocketFactory);
                        ReflectionUtil.setFields((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class, (Object)sniffySSLSocketFactory);
                    }
                } else {
                    LOG.info("Java 12- detected - attempt to update singleton inside javax.net.ssl.SSLSocketFactory");
                    originalSSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField(SSLSocketFactory.class, null, SSLSocketFactory.class);
                    if (null != originalSSLSocketFactory) {
                        SniffySSLSocketFactory sniffySSLSocketFactory = new SniffySSLSocketFactory(originalSSLSocketFactory);
                        LOG.info("Replacing " + originalSSLSocketFactory + " with " + sniffySSLSocketFactory);
                        ReflectionUtil.setFields(SSLSocketFactory.class, null, SSLSocketFactory.class, (Object)sniffySSLSocketFactory);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall() throws NoSuchAlgorithmException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        LOG.info("Uninstalling Sniffy JSSE providers and wrappers");
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            Provider.Service defaultSSLContextSpiProviderService;
            Object[] providers = Security.getProviders();
            LOG.info("Wrapped security providers are " + Arrays.toString(providers));
            int j = 1;
            for (int i = 0; i < providers.length; ++i) {
                Object provider = providers[i];
                if (provider instanceof SniffySSLContextSpiProvider) {
                    if (((Provider)provider).getName().startsWith("Sniffy-")) {
                        Security.removeProvider(((Provider)provider).getName());
                        continue;
                    }
                    Security.removeProvider(((Provider)provider).getName());
                    Provider originalProvider = ((SniffySSLContextSpiProvider)provider).getOriginalProvider();
                    Security.insertProviderAt(originalProvider, j);
                    LOG.info("Unwrapped provider " + ((Provider)provider).getName() + "; replaced " + provider + " with " + originalProvider);
                    ++j;
                    continue;
                }
                ++j;
            }
            Provider firstSSLContextSpiProviderWithDefaultSSLContextSpi = null;
            block4: for (Provider provider : Security.getProviders()) {
                for (Provider.Service service : provider.getServices()) {
                    if (!SSLCONTEXT.equals(service.getType()) || !"Default".equalsIgnoreCase(service.getAlgorithm())) continue;
                    firstSSLContextSpiProviderWithDefaultSSLContextSpi = provider;
                    continue block4;
                }
            }
            if (null != firstSSLContextSpiProviderWithDefaultSSLContextSpi && null != (defaultSSLContextSpiProviderService = firstSSLContextSpiProviderWithDefaultSSLContextSpi.getService(SSLCONTEXT, "Default"))) {
                SSLSocketFactory originalSSLSocketFactory;
                LOG.info("Identified default SSLContext service provider - " + firstSSLContextSpiProviderWithDefaultSSLContextSpi + " with service " + defaultSSLContextSpiProviderService);
                SniffySSLContext defaultSSLContext = new SniffySSLContext((SSLContextSpi)defaultSSLContextSpiProviderService.newInstance(null), firstSSLContextSpiProviderWithDefaultSSLContextSpi, "Default");
                LOG.info("Setting SSLContext.default to " + defaultSSLContext);
                SSLContext.setDefault(defaultSSLContext);
                if (JVMUtil.getVersion() >= 13) {
                    LOG.info("Java 13+ detected - attempt to update javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder");
                    SSLSocketFactory sniffySSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class);
                    if (sniffySSLSocketFactory instanceof SniffySSLSocketFactory) {
                        originalSSLSocketFactory = ((SniffySSLSocketFactory)sniffySSLSocketFactory).getDelegate();
                        LOG.info("Replacing " + sniffySSLSocketFactory + " with " + originalSSLSocketFactory);
                        ReflectionUtil.setFields((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class, (Object)originalSSLSocketFactory);
                    } else if (null == sniffySSLSocketFactory) {
                        LOG.info("Removing javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder");
                        ReflectionUtil.setFields((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class, null);
                    }
                } else {
                    LOG.info("Java 12- detected - attempt to update singleton inside javax.net.ssl.SSLSocketFactory");
                    SSLSocketFactory sniffySSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField(SSLSocketFactory.class, null, SSLSocketFactory.class);
                    if (sniffySSLSocketFactory instanceof SniffySSLSocketFactory) {
                        originalSSLSocketFactory = ((SniffySSLSocketFactory)sniffySSLSocketFactory).getDelegate();
                        LOG.info("Replacing " + sniffySSLSocketFactory + " with " + originalSSLSocketFactory);
                        ReflectionUtil.setFields(SSLSocketFactory.class, null, SSLSocketFactory.class, (Object)originalSSLSocketFactory);
                    } else if (null == sniffySSLSocketFactory) {
                        LOG.info("Removing javax.net.ssl.SSLSocketFactory static fields of type SSLSocketFactory");
                        ReflectionUtil.setFields(SSLSocketFactory.class, null, SSLSocketFactory.class, null);
                        LOG.info("Setting javax.net.ssl.SSLSocketFactory static fields of type boolean to false");
                        ReflectionUtil.setFirstField(SSLSocketFactory.class, null, Boolean.TYPE, (Object)false);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

