/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.tls;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.tls.SniffySSLContext;
import io.sniffy.tls.SniffySSLContextSpiProvider;
import io.sniffy.tls.SniffySSLSocketFactory;
import io.sniffy.util.JVMUtil;
import io.sniffy.util.ReflectionUtil;
import io.sniffy.util.StackTraceExtractor;
import java.security.Provider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSocketFactory;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;

class SniffyThreadLocalProviderList
extends ThreadLocal<ProviderList> {
    private static final Polyglog LOG = PolyglogFactory.log(SniffyThreadLocalProviderList.class);
    private final ThreadLocal<ProviderList> delegate = new ThreadLocal();
    private final ThreadLocal<Boolean> insideSetProviderList = new ThreadLocal();

    SniffyThreadLocalProviderList() {
    }

    @Override
    public ProviderList get() {
        ProviderList providerList = this.delegate.get();
        if (null == providerList && !Boolean.TRUE.equals(this.insideSetProviderList.get()) && StackTraceExtractor.hasClassAndMethodInStackTrace((String)Providers.class.getName(), (String)"setProviderList")) {
            this.insideSetProviderList.set(true);
            LOG.info("Sniffy detected call to Providers.setProviderList() - setting flag insideSetProviderList to true");
            return ProviderList.newList(new Provider[0]);
        }
        return providerList;
    }

    private static Map.Entry<ProviderList, SniffySSLContextSpiProvider> wrapProviderList(ProviderList value) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        ArrayList<Provider> wrappedProviderList = new ArrayList<Provider>();
        SniffySSLContextSpiProvider firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = null;
        List<Provider> originalSecurityProviders = value.providers();
        boolean wrappedAtLeastOneProvider = false;
        for (Provider originalSecurityProvider : originalSecurityProviders) {
            if (!(originalSecurityProvider instanceof SniffySSLContextSpiProvider)) {
                boolean hasSSLContextService = false;
                boolean hasDefaultSSLContextService = false;
                for (Provider.Service service : originalSecurityProvider.getServices()) {
                    if (!"SSLContext".equals(service.getType())) continue;
                    hasSSLContextService = true;
                    if (!"Default".equalsIgnoreCase(service.getAlgorithm())) continue;
                    hasDefaultSSLContextService = true;
                    break;
                }
                if (hasSSLContextService) {
                    wrappedAtLeastOneProvider = true;
                    String originalProviderName = originalSecurityProvider.getName();
                    SniffySSLContextSpiProvider sniffySSLContextSpiProvider = new SniffySSLContextSpiProvider(originalSecurityProvider, "Sniffy-" + originalProviderName, 3.0, "SniffySSLContextProvider");
                    if (hasDefaultSSLContextService && null == firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi) {
                        firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = sniffySSLContextSpiProvider;
                    }
                    wrappedProviderList.add(sniffySSLContextSpiProvider);
                    wrappedProviderList.add(new SniffySSLContextSpiProvider(originalSecurityProvider));
                    continue;
                }
                wrappedProviderList.add(originalSecurityProvider);
                continue;
            }
            if (null == firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi) {
                firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = (SniffySSLContextSpiProvider)originalSecurityProvider;
            }
            wrappedProviderList.add(originalSecurityProvider);
        }
        return new AbstractMap.SimpleImmutableEntry<ProviderList, Object>(wrappedAtLeastOneProvider ? ProviderList.newList(wrappedProviderList.toArray(new Provider[0])) : value, firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi);
    }

    @Override
    public void set(ProviderList value) {
        block15: {
            try {
                if (null != this.delegate.get() || !Boolean.TRUE.equals(this.insideSetProviderList.get()) || 1 != ((Number)ReflectionUtil.getField(Providers.class, null, (String)"threadListsUsed")).intValue()) break block15;
                if (StackTraceExtractor.hasClassAndMethodInStackTrace((String)Providers.class.getName(), (String)"setProviderList")) {
                    try {
                        LOG.info("Wrapping ProviderList " + value);
                        Map.Entry<ProviderList, SniffySSLContextSpiProvider> tuple = SniffyThreadLocalProviderList.wrapProviderList(value);
                        LOG.info("Wrapped ProviderList " + tuple.getKey());
                        LOG.info("First SniffySSLContextSpiProvider with default SSLContextSPI is " + tuple.getValue());
                        if (value == tuple.getKey()) {
                            LOG.info("ProviderList wasn't changed - invoking original Providers.setSystemProviderList() method");
                            ReflectionUtil.invokeMethod(Providers.class, null, (String)"setSystemProviderList", ProviderList.class, (Object)value, Void.class);
                        } else {
                            Provider.Service defaultSniffySSLContextSpiProviderService;
                            value = tuple.getKey();
                            LOG.info("ProviderList wasn't changed - invoking original Providers.setSystemProviderList() method with wrapped list");
                            ReflectionUtil.invokeMethod(Providers.class, null, (String)"setSystemProviderList", ProviderList.class, (Object)value, Void.class);
                            SniffySSLContextSpiProvider firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi = tuple.getValue();
                            if (null != firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi && null != (defaultSniffySSLContextSpiProviderService = firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi.getService("SSLContext", "Default"))) {
                                try {
                                    SniffySSLContext defaultSniffySSLContext = new SniffySSLContext((SSLContextSpi)defaultSniffySSLContextSpiProviderService.newInstance(null), firstSniffySSLContextSpiProviderWithDefaultSSLContextSpi, "Default");
                                    LOG.info("Setting SSLContext.default to " + defaultSniffySSLContext);
                                    SSLContext.setDefault(defaultSniffySSLContext);
                                    if (JVMUtil.getVersion() >= 13) {
                                        LOG.info("Java 13+ detected - attempt to update javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder");
                                        SSLSocketFactory originalSSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class);
                                        if (null != originalSSLSocketFactory) {
                                            SniffySSLSocketFactory sniffySSLSocketFactory = new SniffySSLSocketFactory(originalSSLSocketFactory);
                                            LOG.info("Replacing " + originalSSLSocketFactory + " with " + sniffySSLSocketFactory);
                                            ReflectionUtil.setFields((String)"javax.net.ssl.SSLSocketFactory$DefaultFactoryHolder", null, SSLSocketFactory.class, (Object)sniffySSLSocketFactory);
                                        }
                                    } else {
                                        LOG.info("Java 12- detected - attempt to update singleton inside javax.net.ssl.SSLSocketFactory");
                                        SSLSocketFactory originalSSLSocketFactory = (SSLSocketFactory)ReflectionUtil.getFirstField(SSLSocketFactory.class, null, SSLSocketFactory.class);
                                        if (null != originalSSLSocketFactory) {
                                            SniffySSLSocketFactory sniffySSLSocketFactory = new SniffySSLSocketFactory(originalSSLSocketFactory);
                                            LOG.info("Replacing " + originalSSLSocketFactory + " with " + sniffySSLSocketFactory);
                                            ReflectionUtil.setFields(SSLSocketFactory.class, null, SSLSocketFactory.class, (Object)sniffySSLSocketFactory);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    LOG.error(e);
                                }
                            }
                        }
                        LOG.info("Sniffy detected exit from Providers.setProviderList() - setting flag insideSetProviderList to false");
                        this.insideSetProviderList.set(false);
                        return;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                LOG.info("Sniffy detected exit from Providers.setProviderList() - setting flag insideSetProviderList to false");
                this.insideSetProviderList.set(false);
            }
            catch (NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        this.delegate.set(value);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

