/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.test;

import io.sniffy.Expectation;
import io.sniffy.Expectations;
import io.sniffy.NoQueriesAllowed;
import io.sniffy.socket.NoSocketsAllowed;
import io.sniffy.socket.SocketExpectation;
import io.sniffy.socket.SocketExpectations;
import io.sniffy.sql.NoSql;
import io.sniffy.sql.SqlExpectation;
import io.sniffy.sql.SqlExpectations;
import io.sniffy.util.Range;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnnotationProcessor {
    public static List<SocketExpectation> buildSocketExpectationList(SocketExpectation socketExpectation, SocketExpectations socketExpectations, NoSocketsAllowed noSocketsAllowed) {
        ArrayList<SocketExpectation> socketExpectationList = new ArrayList<SocketExpectation>();
        if (null != socketExpectation && null != noSocketsAllowed) {
            throw new IllegalArgumentException("Cannot specify @Expectation and @NotAllowedQueries on one test method");
        }
        if (null != socketExpectations && null != noSocketsAllowed) {
            throw new IllegalArgumentException("Cannot specify @Expectations and @NotAllowedQueries on one test method");
        }
        if (null != socketExpectations || null != socketExpectation) {
            if (null != socketExpectation) {
                socketExpectationList.add(socketExpectation);
            }
            if (null != socketExpectations) {
                socketExpectationList.addAll(Arrays.asList(socketExpectations.value()));
            }
            for (SocketExpectation expectation1 : socketExpectationList) {
                Range.parse(expectation1.connections());
            }
        } else if (null != noSocketsAllowed) {
            SocketExpectation annotation = NoSocketsAllowed.class.getAnnotation(SocketExpectation.class);
            socketExpectationList.add(annotation);
        }
        return socketExpectationList;
    }

    public static List<SocketExpectation> buildSocketExpectationList(Method method) {
        SocketExpectations socketExpectations = method.getAnnotation(SocketExpectations.class);
        SocketExpectation socketExpectation = method.getAnnotation(SocketExpectation.class);
        NoSocketsAllowed noSocketsAllowed = method.getAnnotation(NoSocketsAllowed.class);
        Class<?> testClass = method.getDeclaringClass();
        while (null == socketExpectations && null == socketExpectation && null == noSocketsAllowed && !Object.class.equals(testClass)) {
            socketExpectations = testClass.getAnnotation(SocketExpectations.class);
            socketExpectation = testClass.getAnnotation(SocketExpectation.class);
            noSocketsAllowed = testClass.getAnnotation(NoSocketsAllowed.class);
            testClass = testClass.getSuperclass();
        }
        return AnnotationProcessor.buildSocketExpectationList(socketExpectation, socketExpectations, noSocketsAllowed);
    }

    public static List<SqlExpectation> buildSqlExpectationList(SqlExpectations expectations, SqlExpectation expectation, NoSql notAllowedQueries) {
        ArrayList<SqlExpectation> expectationList = new ArrayList<SqlExpectation>();
        if (null != expectation && null != notAllowedQueries) {
            throw new IllegalArgumentException("Cannot specify @Expectation and @NotAllowedQueries on one test method");
        }
        if (null != expectations && null != notAllowedQueries) {
            throw new IllegalArgumentException("Cannot specify @Expectations and @NotAllowedQueries on one test method");
        }
        if (null != expectations || null != expectation) {
            if (null != expectation) {
                expectationList.add(expectation);
            }
            if (null != expectations) {
                expectationList.addAll(Arrays.asList(expectations.value()));
            }
            for (SqlExpectation expectation1 : expectationList) {
                Range.parse(expectation1.count());
                Range.parse(expectation1.rows());
            }
        } else if (null != notAllowedQueries) {
            SqlExpectation annotation = NoSql.class.getAnnotation(SqlExpectation.class);
            expectationList.add(annotation);
        }
        return expectationList;
    }

    public static List<SqlExpectation> buildSqlExpectationList(Method method) {
        SqlExpectations sqlExpectations = method.getAnnotation(SqlExpectations.class);
        SqlExpectation sqlExpectation = method.getAnnotation(SqlExpectation.class);
        NoSql noSql = method.getAnnotation(NoSql.class);
        if (null == sqlExpectations) {
            sqlExpectations = Expectations.SqlExpectationsAdapter.adapter(method.getAnnotation(Expectations.class));
        }
        if (null == sqlExpectation) {
            sqlExpectation = Expectation.SqlExpectationAdapter.adapter(method.getAnnotation(Expectation.class));
        }
        if (null == noSql && null != method.getAnnotation(NoQueriesAllowed.class)) {
            noSql = method.getAnnotation(NoQueriesAllowed.class).annotationType().getAnnotation(NoSql.class);
        }
        return AnnotationProcessor.buildSqlExpectationList(method.getDeclaringClass(), sqlExpectations, sqlExpectation, noSql);
    }

    public static List<SqlExpectation> buildSqlExpectationList(Class<?> declaringClass, SqlExpectations sqlExpectations, SqlExpectation sqlExpectation, NoSql noSql) {
        Class<?> testClass = declaringClass;
        while (null == sqlExpectations && null == sqlExpectation && null == noSql && !Object.class.equals(testClass)) {
            sqlExpectations = testClass.getAnnotation(SqlExpectations.class);
            sqlExpectation = testClass.getAnnotation(SqlExpectation.class);
            noSql = testClass.getAnnotation(NoSql.class);
            if (null == sqlExpectations) {
                sqlExpectations = Expectations.SqlExpectationsAdapter.adapter(testClass.getAnnotation(Expectations.class));
            }
            if (null == sqlExpectation) {
                sqlExpectation = Expectation.SqlExpectationAdapter.adapter(testClass.getAnnotation(Expectation.class));
            }
            if (null == noSql && null != testClass.getAnnotation(NoQueriesAllowed.class)) {
                noSql = testClass.getAnnotation(NoQueriesAllowed.class).annotationType().getAnnotation(NoSql.class);
            }
            testClass = testClass.getSuperclass();
        }
        return AnnotationProcessor.buildSqlExpectationList(sqlExpectations, sqlExpectation, noSql);
    }

    public static <T extends Annotation> T getAnnotationRecursive(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (null == annotation) {
            Class<?> clazz = method.getDeclaringClass();
            while (null == annotation && !Object.class.equals(clazz)) {
                annotation = clazz.getAnnotation(annotationClass);
                clazz = clazz.getSuperclass();
            }
        }
        return annotation;
    }
}

