/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.test;

import io.sniffy.test.SharedConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SharedConnectionDataSource
implements DataSource {
    private final ThreadLocal<SharedConnection> lastConnectionThreadLocal = new ThreadLocal();
    private final DataSource targetDataSource;
    private Thread masterConnectionThread;
    private SharedConnection masterConnection;

    public SharedConnectionDataSource(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public synchronized void setCurrentThreadAsMaster() {
        this.masterConnectionThread = Thread.currentThread();
        SharedConnection lastConnection = this.lastConnectionThreadLocal.get();
        try {
            if (null != lastConnection && !lastConnection.getDelegate().isClosed()) {
                this.masterConnection = lastConnection;
                this.masterConnection.markAsMaster();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void resetMasterConnection() throws InterruptedException {
        this.masterConnectionThread = null;
        if (null != this.masterConnection) {
            this.masterConnection.waitForAllSlavesToFinish();
            this.masterConnection = null;
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public synchronized Connection getConnection(String username, String password) throws SQLException {
        if (null == this.masterConnectionThread) {
            return this.obtainConnection(username, password).createProxy();
        }
        if (null == this.masterConnection) {
            if (Thread.currentThread() == this.masterConnectionThread) {
                this.masterConnection = this.obtainConnection(username, password);
                return this.masterConnection.createMasterProxy();
            }
            return this.obtainConnection(username, password).createProxy();
        }
        return this.masterConnection.createSlaveProxy();
    }

    private SharedConnection obtainConnection(String username, String password) throws SQLException {
        Connection targetConnection = null == username && null == password ? this.targetDataSource.getConnection() : this.targetDataSource.getConnection(username, password);
        SharedConnection sharedConnection = new SharedConnection(targetConnection);
        this.lastConnectionThreadLocal.set(sharedConnection);
        return sharedConnection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.targetDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.targetDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.targetDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.targetDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.targetDataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.targetDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.targetDataSource.isWrapperFor(iface);
    }
}

