/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.test;

import io.sniffy.sql.JdbcInvocationHandler;
import io.sniffy.test.SharedConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class SlaveConnection
extends JdbcInvocationHandler<Connection> {
    private final Set<String> IGNORED_METHOD_NAMES = new HashSet<String>(Arrays.asList("setAutoCommit", "commit", "rollback", "close", "setReadOnly", "setTransactionIsolation", "setTypeMap", "setHoldability", "setSavepoint", "releaseSavepoint", "abort", "setNetworkTimeout"));
    private volatile boolean closed;
    private final Semaphore closeSemaphore = new Semaphore(1);

    public SlaveConnection(SharedConnection master) {
        super(null, (Wrapper)master.getDelegate());
        this.closeSemaphore.acquireUninterruptibly();
        master.addSlaveConnection(this);
    }

    protected void waitForClose() throws InterruptedException {
        while (!this.closed) {
            this.closeSemaphore.acquire();
        }
    }

    private void close() {
        this.closed = true;
        this.closeSemaphore.release();
    }

    protected Object invokeImpl(Connection proxy, String methodName, Method method, Object[] args) throws Throwable {
        if ("close".equals(methodName)) {
            this.close();
            return null;
        }
        if (this.IGNORED_METHOD_NAMES.contains(methodName)) {
            return null;
        }
        return super.invokeImpl((Wrapper)proxy, methodName, method, args);
    }
}

