/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ProjectTraversal {
    private MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private JSONObject tree;

    public JSONObject getTree() {
        return this.tree;
    }

    public ProjectTraversal(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        if (project == null || repoSystem == null || repoSession == null) {
            throw new InvalidParameterException();
        }
        this.project = project;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        try {
            this.collectDependencies();
        }
        catch (DependencyCollectionException e) {
            this.tree = new JSONObject();
        }
    }

    private void collectDependencies() throws DependencyCollectionException {
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, "compile"));
        collectRequest.setRepositories(ProjectTraversal.newRepositories());
        CollectResult collectResult = this.repoSystem.collectDependencies(this.repoSession, collectRequest);
        DependencyNode node = collectResult.getRoot();
        this.tree = this.getJsonTree(node);
    }

    private JSONObject getJsonTree(DependencyNode node) {
        JSONObject root = this.getJsonNode(node, null);
        root.put((Object)"packageFormatVersion", (Object)"mvn:0.0.1");
        return root;
    }

    private JSONObject getJsonNode(DependencyNode depNode, JSONArray ancestors) {
        Artifact artifact = depNode.getArtifact();
        JSONObject treeNode = this.createTreeNode(artifact, ancestors);
        List children = depNode.getChildren();
        JSONObject dependencies = new JSONObject();
        for (DependencyNode childDep : children) {
            Artifact childArtifact = childDep.getArtifact();
            JSONObject childNode = this.getJsonNode(childDep, (JSONArray)treeNode.get((Object)"from"));
            dependencies.put((Object)(childArtifact.getGroupId() + ":" + childArtifact.getArtifactId()), (Object)childNode);
        }
        treeNode.put((Object)"dependencies", (Object)dependencies);
        return treeNode;
    }

    private JSONObject createTreeNode(Artifact artifact, JSONArray ancestors) {
        JSONObject treeNode = new JSONObject();
        treeNode.put((Object)"groupId", (Object)artifact.getGroupId());
        treeNode.put((Object)"artifactId", (Object)artifact.getArtifactId());
        treeNode.put((Object)"packaging", (Object)artifact.getExtension());
        treeNode.put((Object)"version", (Object)artifact.getVersion());
        treeNode.put((Object)"name", (Object)(artifact.getGroupId() + ":" + artifact.getArtifactId()));
        JSONArray from = new JSONArray();
        if (ancestors != null) {
            from.addAll((Collection)ancestors);
        }
        from.add((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId() + "@" + artifact.getVersion()));
        treeNode.put((Object)"from", (Object)from);
        return treeNode;
    }

    private static List<RemoteRepository> newRepositories() {
        return new ArrayList<RemoteRepository>(Arrays.asList(ProjectTraversal.newCentralRepository()));
    }

    private static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build();
    }
}

