/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import io.snyk.maven.plugins.Constants;
import io.snyk.maven.plugins.ProjectTraversal;
import io.snyk.maven.plugins.SnykPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Mojo(name="test")
public class SnykTest
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter
    private String apiToken = "";
    @Parameter
    private String org = "";
    @Parameter
    private String failOnSeverity = "low";
    @Parameter
    private String endpoint = "https://snyk.io/api";
    private String baseUrl = "";
    private static int SEVERITY_LOW = 100;
    private static int SEVERITY_MEDIUM = 200;
    private static int SEVERITY_HIGH = 300;
    private static final Map<String, Integer> severityMap = new HashMap<String, Integer>();

    public void execute() throws MojoFailureException {
        try {
            this.executeInternal();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.", t);
            }
            this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.");
            this.getLog().error((CharSequence)"Re-run Maven using the -X switch to enable full debug logging.");
        }
    }

    private void executeInternal() throws MojoExecutionException, MojoFailureException, IOException {
        if (!this.validateParameters()) {
            return;
        }
        JSONObject projectTree = new ProjectTraversal(this.project, this.repoSystem, this.repoSession).getTree();
        HttpResponse response = this.sendDataToSnyk(projectTree);
        this.parseResponse(response);
    }

    private boolean validateParameters() {
        boolean validated = true;
        if (this.apiToken.isEmpty()) {
            Constants.displayAuthError(this.getLog());
            validated = false;
        }
        this.baseUrl = Constants.parseEndpoint(this.endpoint);
        return validated;
    }

    private HttpResponse sendDataToSnyk(JSONObject projectTree) throws IOException {
        HttpPost request = new HttpPost(this.baseUrl + "/api/vuln/maven/?applyPolicy=true");
        request.addHeader("authorization", "token " + this.apiToken);
        request.addHeader("x-is-ci", "false");
        request.addHeader("content-type", "application/json");
        String snykPolicy = SnykPolicy.readPolicyFile(this.project);
        if (snykPolicy != null) {
            projectTree.put((Object)"policy", (Object)snykPolicy);
        }
        StringEntity entity = new StringEntity(projectTree.toString());
        request.setEntity((HttpEntity)entity);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return client.execute((HttpUriRequest)request);
    }

    private void parseResponse(HttpResponse response) throws MojoFailureException {
        if (response.getStatusLine().getStatusCode() >= 400) {
            this.processError(response);
            return;
        }
        JSONObject responseJson = this.parseResponseBody(response);
        if (responseJson.get((Object)"ok") != null && ((Boolean)responseJson.get((Object)"ok")).booleanValue()) {
            this.getLog().info((CharSequence)("\u2713 Tested " + responseJson.get((Object)"dependencyCount") + " dependencies for known vulnerabilities, no vulnerable paths found."));
            return;
        }
        if (responseJson.get((Object)"vulnerabilities") != null) {
            this.processVulns(responseJson);
        } else {
            this.getLog().info((CharSequence)((String)responseJson.get((Object)"summary")));
        }
    }

    private void processError(HttpResponse response) {
        if (response.getStatusLine().toString().contains("401")) {
            Constants.displayAuthError(this.getLog());
        } else {
            this.getLog().error((CharSequence)("Bad response from Snyk: " + response.getStatusLine().toString()));
        }
    }

    private JSONObject parseResponseBody(HttpResponse response) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonObject = (JSONObject)parser.parse((Reader)new BufferedReader(new InputStreamReader(response.getEntity().getContent())));
            return jsonObject;
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }

    private void processVulns(JSONObject responseJson) throws MojoFailureException {
        HashSet<String> vulnIdSet = new HashSet<String>();
        JSONArray vulns = (JSONArray)responseJson.get((Object)"vulnerabilities");
        int highestSeverity = SEVERITY_LOW;
        for (JSONObject vuln : vulns) {
            vulnIdSet.add((String)vuln.get((Object)"id"));
            Integer severityInt = severityMap.get(vuln.get((Object)"severity"));
            if (severityInt != null && severityInt > highestSeverity) {
                highestSeverity = severityInt;
            }
            this.printVuln(vuln);
        }
        this.getLog().warn((CharSequence)("Tested " + responseJson.get((Object)"dependencyCount") + " dependencies for known vulnerabilities, found " + vulnIdSet.size() + " vulnerabilities, " + vulns.size() + " vulnerable paths."));
        if (severityMap.containsKey(this.failOnSeverity) && highestSeverity >= severityMap.get(this.failOnSeverity)) {
            String maxSeverity = this.failOnSeverity.toLowerCase();
            String msg = "Found vulnerabilities with severity " + maxSeverity;
            if (!maxSeverity.equals("high")) {
                msg = msg + " or higher";
            }
            msg = msg + ".";
            throw new MojoFailureException(msg);
        }
    }

    private void printVuln(JSONObject vuln) {
        this.getLog().warn((CharSequence)("\u2717 " + vuln.get((Object)"severity") + " severity vulnerability found on " + vuln.get((Object)"moduleName") + "@" + vuln.get((Object)"version")));
        this.getLog().warn((CharSequence)("- desc: " + vuln.get((Object)"title")));
        this.getLog().warn((CharSequence)("- info: " + this.baseUrl + "/vuln/" + vuln.get((Object)"id")));
        if (vuln.get((Object)"from") != null) {
            JSONArray fromArr = (JSONArray)vuln.get((Object)"from");
            String fromStr = "";
            for (int i = 0; i < fromArr.size(); ++i) {
                fromStr = fromStr + fromArr.get(i) + " > ";
            }
            fromStr = fromStr.substring(0, fromStr.length() - 3);
            this.getLog().warn((CharSequence)("- from: " + fromStr));
        }
        this.getLog().warn((CharSequence)"");
    }

    static {
        severityMap.put("low", SEVERITY_LOW);
        severityMap.put("medium", SEVERITY_MEDIUM);
        severityMap.put("high", SEVERITY_HIGH);
    }
}

