/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public class HttpClientHelper {
    private final Log log;
    private final Settings settings;

    public HttpClientHelper(Log log, Settings settings) {
        this.log = log;
        this.settings = settings;
    }

    public HttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        return this.addProxy(httpClientBuilder).build();
    }

    private HttpClientBuilder addProxy(HttpClientBuilder builder) {
        Proxy settingsProxy = this.settings.getActiveProxy();
        if (settingsProxy != null) {
            this.getLog().debug((CharSequence)"proxy server present, trying to set the first active one");
            String proxyHost = settingsProxy.getHost();
            int proxyPort = settingsProxy.getPort();
            String proxyUsername = settingsProxy.getUsername();
            String proxyPassword = settingsProxy.getPassword();
            if (proxyHost != null && !proxyHost.isEmpty()) {
                this.getLog().debug((CharSequence)("Using proxy=" + proxyHost + " with port=" + proxyPort + "."));
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                builder.setProxy(proxy);
                this.prepareCredentials(builder, proxyUsername, proxyPassword);
            }
        }
        return builder;
    }

    private void prepareCredentials(HttpClientBuilder builder, String proxyUsername, String proxyPassword) {
        if (proxyUsername != null && !proxyUsername.isEmpty()) {
            this.getLog().debug((CharSequence)("Using proxy user name=" + proxyUsername + "."));
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    private Log getLog() {
        return this.log;
    }
}

