/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import io.snyk.maven.plugins.Constants;
import io.snyk.maven.plugins.HttpClientHelper;
import io.snyk.maven.plugins.ProjectTraversal;
import io.snyk.maven.plugins.SnykPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Mojo(name="monitor")
public class SnykMonitor
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteProjectRepositories;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remotePluginRepositories;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component
    private RuntimeInformation runtimeInformation;
    @Parameter
    private String apiToken = "";
    @Parameter
    private String org = "";
    @Parameter
    private String endpoint = "https://snyk.io/api";
    @Parameter
    private boolean includeProvidedDependencies = true;
    @Parameter
    private boolean failOnAuthError = false;
    @Parameter(property="snyk.skip")
    private boolean skip;
    private String baseUrl = "";

    public void execute() {
        try {
            this.executeInternal();
        }
        catch (Throwable t) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.", t);
            }
            this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.");
            this.getLog().error((CharSequence)"Re-run Maven using the -X switch to enable full debug logging.");
        }
    }

    private void executeInternal() throws IOException, ParseException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Security tests are skipped.");
            return;
        }
        if (!this.validateParameters()) {
            return;
        }
        for (RemoteRepository remoteProjectRepository : this.remoteProjectRepositories) {
            this.getLog().debug((CharSequence)("Remote project repository: " + remoteProjectRepository));
        }
        for (RemoteRepository remotePluginRepository : this.remotePluginRepositories) {
            this.getLog().debug((CharSequence)("Remote plugin repository: " + remotePluginRepository));
        }
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>(this.remoteProjectRepositories);
        remoteRepositories.addAll(this.remotePluginRepositories);
        JSONObject projectTree = new ProjectTraversal(this.project, this.repoSystem, this.repoSession, remoteRepositories, this.includeProvidedDependencies).getTree();
        HttpResponse response = this.sendDataToSnyk(projectTree);
        this.parseResponse(response);
    }

    private boolean validateParameters() throws MojoFailureException {
        boolean validated = true;
        if (this.apiToken.equals("")) {
            Constants.displayAuthError(this.getLog(), this.failOnAuthError);
            validated = false;
        }
        this.baseUrl = Constants.parseEndpoint(this.endpoint);
        return validated;
    }

    private HttpResponse sendDataToSnyk(JSONObject projectTree) throws IOException {
        HttpPut request = new HttpPut(this.baseUrl + "/api/monitor/maven");
        request.addHeader("authorization", "token " + this.apiToken);
        request.addHeader("x-is-ci", "false");
        request.addHeader("content-type", "application/json");
        JSONObject jsonDependencies = this.prepareRequestBody(projectTree);
        StringEntity entity = new StringEntity(jsonDependencies.toString());
        request.setEntity((HttpEntity)entity);
        HttpClientHelper httpClientHelper = new HttpClientHelper(this.getLog(), this.settings);
        HttpClient client = httpClientHelper.buildHttpClient();
        return client.execute((HttpUriRequest)request);
    }

    private JSONObject prepareRequestBody(JSONObject projectTree) {
        JSONObject body = new JSONObject();
        JSONObject meta = new JSONObject();
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        meta.put((Object)"method", (Object)"maven-plugin");
        try {
            meta.put((Object)"hostname", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            meta.put((Object)"hostname", (Object)"");
        }
        meta.put((Object)"id", (Object)(groupId + ":" + artifactId));
        meta.put((Object)"ci", (Object)"false");
        meta.put((Object)"maven", (Object)this.runtimeInformation.getMavenVersion());
        meta.put((Object)"name", (Object)(groupId + ":" + artifactId));
        meta.put((Object)"version", (Object)version);
        meta.put((Object)"org", (Object)this.org);
        body.put((Object)"meta", (Object)meta);
        body.put((Object)"package", (Object)projectTree);
        String snykPolicy = SnykPolicy.readPolicyFile(this.project);
        if (snykPolicy != null) {
            body.put((Object)"policy", (Object)snykPolicy);
        }
        return body;
    }

    private void parseResponse(HttpResponse response) throws IOException, ParseException, MojoFailureException {
        if (response.getStatusLine().getStatusCode() >= 400) {
            this.processError(response);
            return;
        }
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse((Reader)new BufferedReader(new InputStreamReader(response.getEntity().getContent())));
        Boolean ok = (Boolean)jsonObject.get((Object)"ok");
        if (ok != null && ok.booleanValue()) {
            this.getLog().info((CharSequence)"Captured a snapshot of this project's dependencies.");
            this.getLog().info((CharSequence)("Explore this snapshot at " + this.getMonitorWebURL((String)jsonObject.get((Object)"org"), (String)jsonObject.get((Object)"id"))));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Notifications about newly disclosed vulnerabilities related to these dependencies will be emailed to you.");
            this.getLog().info((CharSequence)"");
        } else if (jsonObject.get((Object)"error") != null) {
            this.getLog().error((CharSequence)("There was a problem monitoring the project: " + jsonObject.get((Object)"error")));
        } else if (jsonObject.get((Object)"message") != null) {
            this.getLog().warn((CharSequence)("Could not complete the monitoring action: " + jsonObject.get((Object)"message")));
        }
    }

    private String getMonitorWebURL(String org, String id) {
        return this.baseUrl + "/org/" + org + "/monitor/" + id;
    }

    private void processError(HttpResponse response) throws MojoFailureException {
        if (response.getStatusLine().toString().contains("401")) {
            Constants.displayAuthError(this.getLog(), this.failOnAuthError);
        } else {
            this.getLog().error((CharSequence)("Bad response from Snyk: " + response.getStatusLine().toString()));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Snyk http response: " + this.parseResponseBody(response)));
            }
        }
    }

    private JSONObject parseResponseBody(HttpResponse response) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonObject = (JSONObject)parser.parse((Reader)new BufferedReader(new InputStreamReader(response.getEntity().getContent())));
            return jsonObject;
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }
}

