/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;

public class SnykPolicy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readPolicyFile(MavenProject project) {
        String snykFilename = SnykPolicy.getPolicyFilePath(project);
        if (snykFilename == null) {
            return null;
        }
        String sep = System.getProperty("line.separator");
        try (Stream<String> stream = Files.lines(Paths.get(snykFilename, new String[0]));){
            String string = stream.map(v -> v + sep).reduce("", String::concat);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPolicyFilePath(MavenProject project) {
        if (project == null || project.getBasedir() == null) {
            return null;
        }
        Path baseDir = project.getBasedir().toPath();
        Path filePath = baseDir.resolve(".snyk");
        File f = filePath.toFile();
        if (f.exists() && !f.isDirectory()) {
            return filePath.toString();
        }
        return SnykPolicy.getPolicyFilePath(project.getParent());
    }
}

