/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.maven.plugins;

import io.snyk.maven.plugins.Constants;
import io.snyk.maven.plugins.HttpClientHelper;
import io.snyk.maven.plugins.ProjectTraversal;
import io.snyk.maven.plugins.SnykPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Mojo(name="test")
public class SnykTest
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteProjectRepositories;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remotePluginRepositories;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter
    private String apiToken = "";
    @Parameter
    private String org = "";
    @Parameter
    private String failOnSeverity = "low";
    @Parameter
    private String endpoint = "https://snyk.io/api";
    @Parameter
    private boolean includeProvidedDependencies = true;
    @Parameter
    private boolean failOnAuthError = false;
    @Parameter(property="snyk.skip")
    private boolean skip;
    private String baseUrl = "";
    private static int SEVERITY_LOW = 100;
    private static int SEVERITY_MEDIUM = 200;
    private static int SEVERITY_HIGH = 300;
    private static final Map<String, Integer> severityMap = new HashMap<String, Integer>();

    public void execute() throws MojoFailureException {
        try {
            this.executeInternal();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.", t);
            }
            this.getLog().error((CharSequence)"There was a problem with the Snyk plugin.");
            this.getLog().error((CharSequence)"Re-run Maven using the -X switch to enable full debug logging.");
        }
    }

    private void executeInternal() throws MojoFailureException, IOException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Security tests are skipped");
            return;
        }
        if (!this.validateParameters()) {
            return;
        }
        for (RemoteRepository remoteProjectRepository : this.remoteProjectRepositories) {
            this.getLog().debug((CharSequence)("Remote project repository: " + remoteProjectRepository));
        }
        for (RemoteRepository remotePluginRepository : this.remotePluginRepositories) {
            this.getLog().debug((CharSequence)("Remote plugin repository: " + remotePluginRepository));
        }
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>(this.remoteProjectRepositories);
        remoteRepositories.addAll(this.remotePluginRepositories);
        JSONObject projectTree = new ProjectTraversal(this.project, this.repoSystem, this.repoSession, remoteRepositories, this.includeProvidedDependencies).getTree();
        HttpResponse response = this.sendDataToSnyk(projectTree);
        this.parseResponse(response);
    }

    private boolean validateParameters() throws MojoFailureException {
        boolean validated = true;
        if (this.apiToken.isEmpty()) {
            Constants.displayAuthError(this.getLog(), this.failOnAuthError);
            validated = false;
        }
        this.baseUrl = Constants.parseEndpoint(this.endpoint);
        return validated;
    }

    private HttpResponse sendDataToSnyk(JSONObject projectTree) throws IOException {
        String vulnMavenEndpoint = "/api/vuln/maven/?applyPolicy=true";
        if (this.org != null && !this.org.isEmpty()) {
            vulnMavenEndpoint = vulnMavenEndpoint + "&org=" + this.org;
        }
        HttpPost request = new HttpPost(this.baseUrl + vulnMavenEndpoint);
        request.addHeader("authorization", "token " + this.apiToken);
        request.addHeader("x-is-ci", "false");
        request.addHeader("content-type", "application/json");
        String snykPolicy = SnykPolicy.readPolicyFile(this.project);
        if (snykPolicy != null) {
            projectTree.put((Object)"policy", (Object)snykPolicy);
        }
        StringEntity entity = new StringEntity(projectTree.toString());
        request.setEntity((HttpEntity)entity);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Snyk http request payload: " + projectTree));
        }
        HttpClientHelper httpClientHelper = new HttpClientHelper(this.getLog(), this.settings);
        HttpClient client = httpClientHelper.buildHttpClient();
        return client.execute((HttpUriRequest)request);
    }

    private void parseResponse(HttpResponse response) throws MojoFailureException {
        if (response.getStatusLine().getStatusCode() >= 400) {
            this.processError(response);
            return;
        }
        JSONObject responseJson = this.parseResponseBody(response);
        if (responseJson.get((Object)"ok") != null && ((Boolean)responseJson.get((Object)"ok")).booleanValue()) {
            this.getLog().info((CharSequence)("\u2713 Tested " + responseJson.get((Object)"dependencyCount") + " dependencies for known vulnerabilities, no vulnerable paths found."));
            return;
        }
        if (responseJson.get((Object)"vulnerabilities") != null) {
            this.processVulns(responseJson);
        } else {
            this.getLog().info((CharSequence)((String)responseJson.get((Object)"summary")));
        }
    }

    private void processError(HttpResponse response) throws MojoFailureException {
        if (response.getStatusLine().toString().contains("401")) {
            Constants.displayAuthError(this.getLog(), this.failOnAuthError);
        } else {
            this.getLog().error((CharSequence)("Bad response from Snyk: " + response.getStatusLine().toString()));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Snyk http response: " + this.parseResponseBody(response)));
            }
        }
    }

    private JSONObject parseResponseBody(HttpResponse response) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonObject = (JSONObject)parser.parse((Reader)new BufferedReader(new InputStreamReader(response.getEntity().getContent())));
            return jsonObject;
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }

    private void processVulns(JSONObject responseJson) throws MojoFailureException {
        HashSet<String> vulnIdSet = new HashSet<String>();
        JSONArray vulns = (JSONArray)responseJson.get((Object)"vulnerabilities");
        int highestSeverity = SEVERITY_LOW;
        for (JSONObject vuln : vulns) {
            vulnIdSet.add((String)vuln.get((Object)"id"));
            Integer severityInt = severityMap.get(vuln.get((Object)"severity"));
            if (severityInt != null && severityInt > highestSeverity) {
                highestSeverity = severityInt;
            }
            this.printVuln(vuln);
        }
        this.getLog().warn((CharSequence)("Tested " + responseJson.get((Object)"dependencyCount") + " dependencies for known vulnerabilities, found " + vulnIdSet.size() + " vulnerabilities, " + vulns.size() + " vulnerable paths."));
        if (severityMap.containsKey(this.failOnSeverity) && highestSeverity >= severityMap.get(this.failOnSeverity)) {
            String maxSeverity = this.failOnSeverity.toLowerCase();
            String msg = "Found vulnerabilities with severity " + maxSeverity;
            if (!maxSeverity.equals("high")) {
                msg = msg + " or higher";
            }
            msg = msg + ".";
            throw new MojoFailureException(msg);
        }
    }

    private void printVuln(JSONObject vuln) {
        this.getLog().warn((CharSequence)("\u2717 " + vuln.get((Object)"severity") + " severity vulnerability found on " + vuln.get((Object)"packageName") + "@" + vuln.get((Object)"version")));
        this.getLog().warn((CharSequence)("- desc: " + vuln.get((Object)"title")));
        this.getLog().warn((CharSequence)("- info: " + this.baseUrl + "/vuln/" + vuln.get((Object)"id")));
        if (vuln.get((Object)"from") != null) {
            JSONArray fromArr = (JSONArray)vuln.get((Object)"from");
            this.getLog().warn((CharSequence)("- from: " + this.printJSONArray(fromArr, " > ")));
        }
        this.getLog().warn((CharSequence)("- fix: " + this.findFix(vuln)));
        this.getLog().warn((CharSequence)"");
    }

    private String findFix(JSONObject vuln) {
        JSONArray fixedIn;
        JSONArray fromArr;
        JSONArray upgradePath;
        String noUpgrade = "No direct upgrade available";
        if (vuln.get((Object)"isUpgradable") != null && ((Boolean)vuln.get((Object)"isUpgradable")).booleanValue() && (upgradePath = (JSONArray)vuln.get((Object)"upgradePath")).size() >= 2 && vuln.get((Object)"from") != null && !(fromArr = (JSONArray)vuln.get((Object)"from")).contains(upgradePath.get(1))) {
            return "update to " + upgradePath.get(1);
        }
        if (vuln.get((Object)"fixedIn") != null && !(fixedIn = (JSONArray)vuln.get((Object)"fixedIn")).isEmpty()) {
            noUpgrade = noUpgrade + " - This issue was fixed in versions: " + this.printJSONArray(fixedIn, ", ");
        }
        return noUpgrade;
    }

    private String printJSONArray(JSONArray array, String delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            result.append(object);
            if (!iterator.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    static {
        severityMap.put("low", SEVERITY_LOW);
        severityMap.put("medium", SEVERITY_MEDIUM);
        severityMap.put("high", SEVERITY_HIGH);
    }
}

