/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.download;

import io.snyk.snyk_maven_plugin.download.FileDownloader;
import io.snyk.snyk_maven_plugin.download.Platform;
import io.snyk.snyk_maven_plugin.download.UpdatePolicy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class ExecutableDownloader {
    public static final String SNYK_INTEGRATION_NAME = "MAVEN_PLUGIN";
    private static final String SNYK_CLI_DOWNLOAD_PRIMARY = "https://downloads.snyk.io/cli/%s/%s";
    private static final String SNYK_CLI_DOWNLOAD_SECONDARY = "https://static.snyk.io/cli/%s/%s";
    private static final List<String> SNYK_CLI_DOWNLOAD_URLS = Arrays.asList("https://downloads.snyk.io/cli/%s/%s", "https://static.snyk.io/cli/%s/%s");

    public static File ensure(URL cliDownloadURL, File cliFile, String updatePolicy, FileDownloader downloader) {
        try {
            File checksumFile = new File(cliFile.getPath() + ".sha256");
            if (cliFile.exists() && checksumFile.exists() && ExecutableDownloader.verifyChecksum(cliFile, checksumFile) && !UpdatePolicy.shouldUpdate(updatePolicy, cliFile.lastModified(), System.currentTimeMillis())) {
                return cliFile;
            }
            cliFile.delete();
            checksumFile.delete();
            cliFile.getParentFile().mkdirs();
            URL cliUrlWithUtm = new URL(cliDownloadURL.toString() + "?utm_source=" + SNYK_INTEGRATION_NAME);
            downloader.download(cliUrlWithUtm, cliFile);
            URL checksumUrl = new URL(cliDownloadURL.toString() + ".sha256?utm_source=" + SNYK_INTEGRATION_NAME);
            downloader.download(checksumUrl, checksumFile);
            if (!ExecutableDownloader.verifyChecksum(cliFile, checksumFile)) {
                throw new RuntimeException("computed sha256 checksum for CLI download does not expected");
            }
            cliFile.setExecutable(true);
            return cliFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File iterateAndEnsure(List<URL> cliDownloadURLs, File cliFile, String updatePolicy, FileDownloader downloader) {
        for (URL cliDownloadURL : cliDownloadURLs) {
            try {
                File downloadedFile = ExecutableDownloader.ensure(cliDownloadURL, cliFile, updatePolicy, downloader);
                if (!downloadedFile.exists()) continue;
                return downloadedFile;
            }
            catch (RuntimeException e) {
                System.err.println("Failed to download from '" + cliDownloadURL + "': " + e);
            }
        }
        throw new RuntimeException("Failed to download from URLs");
    }

    static String downloadToString(URL url) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        String all = br.lines().collect(Collectors.joining("\n"));
        return all;
    }

    public static String getLatestVersion() throws IOException {
        String version = "v" + ExecutableDownloader.downloadToString(new URL("https://downloads.snyk.io/cli/stable/version")).trim();
        return version;
    }

    public static List<URL> getDownloadUrls(Platform platform, String version) {
        ArrayList<URL> downloadUrls = new ArrayList<URL>();
        for (String url : SNYK_CLI_DOWNLOAD_URLS) {
            downloadUrls.add(ExecutableDownloader.getDownloadUrl(url, platform, version));
        }
        return downloadUrls;
    }

    public static URL getDownloadUrl(String url, Platform platform, String version) {
        try {
            if (version.equals("stable")) {
                String actualLatestVersion = ExecutableDownloader.getLatestVersion();
                return new URL(String.format(url, actualLatestVersion, platform.snykExecutableFileName));
            }
            return new URL(String.format(url, version, platform.snykExecutableFileName));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Download URL is malformed", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed resolving 'latest' version", e);
        }
    }

    public static String extractChecksumValue(File checksumFile) throws IOException, RuntimeException {
        List<String> lines = Files.readAllLines(checksumFile.toPath());
        if (lines.size() == 1) {
            return lines.get(0).substring(0, 64);
        }
        throw new RuntimeException("Invalid number of lines in a checksum file");
    }

    public static String computeChecksum(File targetFile) throws IOException {
        byte[] bytes = Files.readAllBytes(targetFile.toPath());
        return DigestUtils.sha256Hex((byte[])bytes);
    }

    public static boolean verifyChecksum(File targetFile, File checksumFile) throws IOException {
        String expectedChecksum = ExecutableDownloader.extractChecksumValue(checksumFile);
        String computed = ExecutableDownloader.computeChecksum(targetFile);
        return computed.equals(expectedChecksum);
    }
}

