/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.goal;

import io.snyk.snyk_maven_plugin.command.Command;
import io.snyk.snyk_maven_plugin.download.CLIVersions;
import io.snyk.snyk_maven_plugin.download.ExecutableDestination;
import io.snyk.snyk_maven_plugin.download.ExecutableDownloader;
import io.snyk.snyk_maven_plugin.download.Platform;
import io.snyk.snyk_maven_plugin.goal.ComposedMojo;
import io.snyk.snyk_maven_plugin.goal.MojoExecutor;
import io.snyk.snyk_maven_plugin.goal.SnykMojoExecutor;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.logging.MessageUtils;

public abstract class SnykMojo
extends ComposedMojo {
    @Parameter
    private String apiToken;
    @Parameter
    private List<String> args;
    @Parameter(property="snyk.skip")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean failOnIssues;
    @Parameter
    private CLI cli;
    private final boolean color = MessageUtils.isColorEnabled();
    private final Platform platform = Platform.current();
    private final MojoExecutor executor = new SnykMojoExecutor(this);

    protected SnykMojo() {
    }

    public boolean getFailOnIssues() {
        return this.failOnIssues;
    }

    public List<String> getArguments() {
        return Optional.ofNullable(this.args).orElse(Collections.emptyList());
    }

    public Optional<String> getApiToken() {
        return Optional.ofNullable(this.apiToken);
    }

    public Optional<File> getExecutable() {
        return Optional.ofNullable(this.cli).map(cli -> ((CLI)cli).executable);
    }

    public String getDownloadVersion() {
        return Optional.ofNullable(this.cli).map(cli -> ((CLI)cli).version).map(CLIVersions::sanitize).orElse("stable");
    }

    public boolean shouldSkip() {
        return this.skip;
    }

    public boolean supportsColor() {
        return this.color;
    }

    public File getDownloadDestination() {
        return Optional.ofNullable(this.cli).map(cli -> ((CLI)cli).downloadDestination).orElseGet(() -> {
            Map<String, String> environmentVariables = System.getenv();
            Optional<Path> homeDirectory = Optional.ofNullable(System.getProperty("user.home")).map(x$0 -> Paths.get(x$0, new String[0]));
            return ExecutableDestination.getDownloadDestination(this.platform, homeDirectory, environmentVariables);
        });
    }

    public List<URL> getDownloadUrls() {
        return ExecutableDownloader.getDownloadUrls(this.platform, this.getDownloadVersion());
    }

    public String getUpdatePolicy() {
        if (!this.getDownloadVersion().equals("stable")) {
            return "always";
        }
        return Optional.ofNullable(this.cli).map(cli -> ((CLI)cli).updatePolicy).orElse("daily");
    }

    @Override
    public MojoExecutor getExecutor() {
        return this.executor;
    }

    public abstract Command getCommand();

    public static class CLI {
        @Parameter
        private File executable;
        @Parameter
        private String version;
        @Parameter
        private String updatePolicy;
        @Parameter
        private File downloadDestination;
    }
}

