/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web;

import com.github.jknack.handlebars.Handlebars;
import com.google.common.base.Preconditions;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.setup.AdminEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.soabase.web.assets.InternalAssetServlet;
import io.soabase.web.config.ConfigAccessor;
import io.soabase.web.config.WebConfiguration;
import io.soabase.web.context.ContextFactory;
import io.soabase.web.filters.RootFilter;
import io.soabase.web.language.RequestLanguage;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ContextFactory contextFactory;
    private final ConfigAccessor<T> configAccessor;
    private volatile InternalAssetServlet assetServlet;
    private volatile RequestLanguage requestLanguage;

    public WebBundle(ContextFactory contextFactory, ConfigAccessor<T> configAccessor) {
        this.contextFactory = contextFactory;
        this.configAccessor = configAccessor;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.addServlet(environment, this.configAccessor.getAppConfiguration(configuration), false);
        Optional<WebConfiguration> adminConfiguration = this.configAccessor.getAdminConfiguration(configuration);
        if (adminConfiguration.isPresent()) {
            this.addServlet(environment, adminConfiguration.get(), true);
        }
    }

    public Handlebars getHandlebars() {
        Preconditions.checkNotNull((Object)((Object)this.assetServlet), (Object)"Handlebars not available until run() has been called");
        return this.assetServlet.getHandlebars();
    }

    public RequestLanguage getRequestLanguage() {
        Preconditions.checkNotNull((Object)this.requestLanguage, (Object)"RequestLanguage not available until run() has been called");
        return this.requestLanguage;
    }

    protected InternalAssetServlet newInternalAssetServlet(Environment environment, WebConfiguration configuration, ContextFactory contextFactory, RequestLanguage requestLanguage) {
        return new InternalAssetServlet(configuration, contextFactory, requestLanguage, environment);
    }

    private void addServlet(Environment environment, WebConfiguration configuration, boolean isAdmin) {
        AdminEnvironment servlets = isAdmin ? environment.admin() : environment.servlets();
        this.requestLanguage = configuration.requestLanguage.buildAndInstall(environment, (ServletEnvironment)servlets);
        this.assetServlet = this.newInternalAssetServlet(environment, configuration, this.contextFactory, this.requestLanguage);
        servlets.addServlet("soabase-web-asset-servlet", (Servlet)this.assetServlet).addMapping(new String[]{configuration.uriPath + "/*"});
        if (configuration.addRootFilter) {
            servlets.addFilter("soabase-web-root-filter", (Filter)new RootFilter(configuration.uriPath + configuration.defaultFile)).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/"});
        }
    }
}

