/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web.assets;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import io.dropwizard.servlets.assets.AssetServlet;
import io.dropwizard.setup.Environment;
import io.soabase.web.assets.ConcatHelper;
import io.soabase.web.assets.WebFileTemplateLoader;
import io.soabase.web.assets.WebTemplateLoader;
import io.soabase.web.assets.WebZipTemplateLoader;
import io.soabase.web.config.WebConfiguration;
import io.soabase.web.context.ContextCache;
import io.soabase.web.context.ContextFactory;
import io.soabase.web.language.RequestLanguage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAssetServlet
extends AssetServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final WebConfiguration configuration;
    private final RequestLanguage requestLanguage;
    private final Handlebars handlebars;
    private final ConcurrentMap<String, Template> templateCache = Maps.newConcurrentMap();
    private final WebTemplateLoader templateLoader;
    private final ContextCache contextCache;

    public InternalAssetServlet(WebConfiguration configuration, ContextFactory contextFactory, RequestLanguage requestLanguage, Environment environment) {
        super("/", configuration.uriPath, configuration.defaultFile.substring(1), Charsets.UTF_8);
        File assetsFile;
        this.configuration = configuration;
        this.requestLanguage = requestLanguage;
        try {
            assetsFile = configuration.assetsFile.getCanonicalFile();
            if (!assetsFile.exists()) {
                throw new RuntimeException("File doesn't exist: " + assetsFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve: " + configuration.assetsFile);
        }
        this.templateLoader = assetsFile.isFile() ? new WebZipTemplateLoader(configuration, assetsFile) : new WebFileTemplateLoader(configuration, assetsFile);
        this.handlebars = new Handlebars((TemplateLoader)this.templateLoader);
        StringHelpers.register((Handlebars)this.handlebars);
        this.handlebars.registerHelper("concat", (Helper)new ConcatHelper(this::getTemplate));
        this.contextCache = new ContextCache(contextFactory, assetsFile, configuration.textDir, configuration.debug, configuration.modelCache.build(environment));
    }

    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = this.pathFromRequest(request);
        String pathExtension = Files.getFileExtension((String)path);
        if (this.configuration.templateExtensions.contains(pathExtension)) {
            this.serveTemplate(request, response, path);
        } else {
            super.doGet(request, response);
        }
    }

    protected String pathFromRequest(HttpServletRequest request) {
        return request.getPathInfo() != null ? request.getPathInfo() : this.configuration.defaultFile;
    }

    private void serveTemplate(HttpServletRequest request, HttpServletResponse response, String path) {
        try {
            Template template = this.getTemplate(path);
            String content = template.apply(this.contextCache.getContext(request, this.requestLanguage.getLanguageCode(request)));
            String mimeTypeOfExtension = request.getServletContext().getMimeType(request.getRequestURI());
            MediaType mediaType = MediaType.parse((String)mimeTypeOfExtension);
            response.setContentType(mediaType.type() + '/' + mediaType.subtype());
            if (mediaType.type().equals("text") || mediaType.subtype().equals("javascript")) {
                response.setCharacterEncoding(Charsets.UTF_8.name());
            }
            response.setContentLength(content.length());
            CharStreams.copy((Readable)new StringReader(content), (Appendable)response.getWriter());
        }
        catch (Exception e) {
            this.log.error("Could not serve template: " + path, (Throwable)e);
        }
    }

    private Template getTemplate(String path) {
        return this.configuration.debug ? this.compile(path) : this.templateCache.computeIfAbsent(path, key -> this.compile(path));
    }

    private Template compile(String path) {
        try {
            return this.handlebars.compile(path.substring(1));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compile: " + path, e);
        }
    }

    protected URL getResourceUrl(String absoluteRequestedResourcePath) {
        return this.templateLoader.getResourceUrl(absoluteRequestedResourcePath);
    }
}

