/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web.context;

import com.github.jknack.handlebars.Context;
import com.google.common.collect.Maps;
import io.soabase.web.cache.HostLanguage;
import io.soabase.web.cache.ModelCache;
import io.soabase.web.cache.ModelMaker;
import io.soabase.web.context.ContextFactory;
import io.soabase.web.context.TextLoader;
import java.io.File;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;

public class ContextCache
implements ModelMaker {
    private final ConcurrentMap<HostLanguage, Context> cache = Maps.newConcurrentMap();
    private final ContextFactory contextFactory;
    private final ModelCache modelCache;
    private final TextLoader textLoader;
    private final boolean debug;

    public ContextCache(ContextFactory contextFactory, File assets, String textDir, boolean debug, ModelCache modelCache) {
        this.contextFactory = contextFactory;
        this.modelCache = modelCache;
        this.textLoader = new TextLoader(assets, textDir, debug);
        this.debug = debug;
    }

    public Context getContext(HttpServletRequest request, String languageCode) {
        HostLanguage hostLanguage = new HostLanguage(request.getServerName(), languageCode);
        Object model = this.debug ? this.createModel(request, hostLanguage) : this.modelCache.getModel(request, hostLanguage, this);
        Context context = Context.newContext((Object)model);
        return Context.newContext((Context)context, this.textLoader.getFor(hostLanguage.getLanguage()));
    }

    @Override
    public Object createModel(HttpServletRequest request, HostLanguage hostLanguage) {
        return this.contextFactory.getModel(request, hostLanguage.getLanguage());
    }
}

