/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web.context;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class TextLoader {
    private final Map<String, Map<String, String>> text;
    private final File assetsFile;
    private final String textDir;

    TextLoader(File assetsFile, String textDir, boolean debug) {
        this.assetsFile = assetsFile;
        this.textDir = textDir;
        this.text = debug ? null : this.loadText();
    }

    Map<String, String> getFor(String languageCode) {
        Map<String, Map<String, String>> localText = this.text != null ? this.text : this.loadText();
        ImmutableMap values = localText.get(languageCode);
        return values != null ? values : ImmutableMap.of();
    }

    private Map<String, Map<String, String>> loadText() {
        return this.assetsFile.isDirectory() ? this.loadTextFromDir() : this.loadTextFromZip();
    }

    private Map<String, Map<String, String>> loadTextFromZip() {
        HashMap text = Maps.newHashMap();
        try {
            ZipFile zipFile = new ZipFile(this.assetsFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(entry.getName());
                if (entry.isDirectory() || !this.textDir.equals(entryFile.getParent())) continue;
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    text.put(this.getKey(entryFile.getName()), this.read(entryFile.getName(), CharStreams.readLines((Readable)new InputStreamReader(stream)).stream()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return text;
    }

    private Map<String, Map<String, String>> loadTextFromDir() {
        File dir = new File(this.assetsFile, this.textDir);
        return StreamSupport.stream(Files.fileTreeTraverser().children((Object)dir).spliterator(), false).map(file -> new AbstractMap.SimpleEntry<String, Map<String, String>>(this.getKey(file.getName()), this.read((File)file))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String getKey(String name) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)name).get(0);
    }

    private Map<String, String> read(File file) {
        try {
            return this.read(file.getName(), Files.readLines((File)file, (Charset)Charsets.UTF_8).stream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> read(String fileName, Stream<String> stream) {
        return stream.map(line -> this.splitLine(fileName, (String)line)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<String, String> splitLine(String fileName, String line) {
        int index = line.indexOf(32);
        if (index < 0 && (index = line.indexOf(9)) < 0 && (index = line.indexOf(61)) < 0) {
            throw new RuntimeException(String.format("Badly formed line in %s: %s", fileName, line));
        }
        String field = line.substring(0, index).trim();
        String value = line.substring(index).trim();
        return new AbstractMap.SimpleEntry<String, String>(field, value);
    }
}

