/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web.filters;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.soabase.web.language.RequestLanguage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageFilter
implements Filter,
RequestLanguage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String cookieName;
    private final String queryParameterName;
    private final String defaultLanguageCode;
    private final Set<String> validLanguageCodes;

    public LanguageFilter(String cookieName, String queryParameterName, String defaultLanguageCode, Set<String> validLanguageCodes) {
        this.cookieName = (String)Preconditions.checkNotNull((Object)cookieName, (Object)"cookieName cannot be null");
        this.queryParameterName = (String)Preconditions.checkNotNull((Object)queryParameterName, (Object)"queryParameterName cannot be null");
        this.defaultLanguageCode = (String)Preconditions.checkNotNull((Object)defaultLanguageCode, (Object)"defaultLanguageCode cannot be null");
        this.validLanguageCodes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(validLanguageCodes, (Object)"validLanguageCodes cannot be null")));
    }

    @Override
    public String getLanguageCode(HttpHeaders httpHeaders, UriInfo uriInfo) {
        Cookie cookie = (Cookie)httpHeaders.getCookies().get(this.cookieName);
        Optional<String> cookieValue = Optional.ofNullable(cookie != null ? cookie.getValue() : null);
        return this.getLanguageCode(uriInfo.getRequestUri().getQuery(), cookieValue);
    }

    @Override
    public String getLanguageCode(HttpServletRequest request) {
        return this.getLanguageCode(request.getQueryString(), this.getCookie(request));
    }

    @Override
    public String getLanguageCode(String queryString, Optional<String> cookie) {
        String code = this.getFromQueryString(queryString, new AtomicReference<String>());
        if (code != null) {
            return code;
        }
        if (cookie.isPresent()) {
            try {
                return this.validate(cookie.get());
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Cookie set to invalid language", (Object)cookie.get());
            }
        }
        return this.defaultLanguageCode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            AtomicReference<String> fixedQueryString = new AtomicReference<String>();
            String queryStringCode = this.getFromQueryString(httpRequest.getQueryString(), fixedQueryString);
            String expectedLanguageCode = (String)MoreObjects.firstNonNull((Object)queryStringCode, (Object)this.getLanguageCode(null, this.getCookie(httpRequest)));
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            Optional<String> foundCookie = this.getCookie(httpRequest);
            if (!foundCookie.isPresent() || !foundCookie.get().equals(expectedLanguageCode)) {
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(this.cookieName, expectedLanguageCode);
                httpResponse.addCookie(cookie);
            }
            if (queryStringCode != null) {
                StringBuffer redirectUrl = httpRequest.getRequestURL();
                if (!fixedQueryString.get().isEmpty()) {
                    redirectUrl.append("?").append(fixedQueryString.get());
                }
                ((HttpServletResponse)response).sendRedirect(redirectUrl.toString());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private String getFromQueryString(String queryString, AtomicReference<String> fixedQueryString) {
        if (queryString != null && !queryString.trim().isEmpty()) {
            fixedQueryString.set(queryString);
            List nameValuePairs = URLEncodedUtils.parse((String)queryString, (Charset)Charsets.UTF_8);
            Optional<NameValuePair> first = nameValuePairs.stream().filter(vp -> vp.getName().equals(this.queryParameterName)).findFirst();
            if (first.isPresent()) {
                try {
                    List copy = nameValuePairs.stream().filter(p -> p != first.get()).collect(Collectors.toList());
                    fixedQueryString.set(URLEncodedUtils.format(copy, (Charset)Charsets.UTF_8));
                    return this.validate(first.get().getValue());
                }
                catch (IllegalArgumentException ignore) {
                    this.log.debug("Query param set to invalid language", (Object)first.get());
                }
            }
        }
        return null;
    }

    private String validate(String code) {
        return this.validLanguageCodes.isEmpty() || this.validLanguageCodes.contains(code) ? code : this.defaultLanguageCode;
    }

    private Optional<String> getCookie(HttpServletRequest httpRequest) {
        return LanguageFilter.getCookies(httpRequest).stream().filter(cookie -> cookie.getName().equals(this.cookieName)).map(javax.servlet.http.Cookie::getValue).findFirst();
    }

    private static List<javax.servlet.http.Cookie> getCookies(HttpServletRequest httpRequest) {
        if (httpRequest.getCookies() != null) {
            return Arrays.asList(httpRequest.getCookies());
        }
        return ImmutableList.of();
    }
}

