/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.web.language;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.setup.Environment;
import io.soabase.web.filters.LanguageFilter;
import io.soabase.web.language.RequestLanguage;
import io.soabase.web.language.RequestLanguageFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="default")
public class DefaultRequestLanguageFactory
implements RequestLanguageFactory {
    @NotNull
    public String cookieName = "soabase_web_langauge";
    @NotNull
    public String queryParameterName = "lang";
    @NotNull
    public String defaultLanguageCode = "en";
    @NotNull
    public Set<String> validLanguageCodes = Collections.emptySet();

    @Override
    public RequestLanguage buildAndInstall(Environment environment, ServletEnvironment servlets) {
        LanguageFilter languageFilter = new LanguageFilter(this.cookieName, this.queryParameterName, this.defaultLanguageCode, this.validLanguageCodes);
        servlets.addFilter("soabase-web-language-filter", (Filter)languageFilter).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        return languageFilter;
    }
}

