/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.parseqs.ParseQS;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public final class JettyWebSocketHandler
extends EngineIoWebSocket
implements WebSocketListener {
    private final EngineIoServer mServer;
    private Session mSession;
    private Map<String, String> mQuery;

    public JettyWebSocketHandler(EngineIoServer server) {
        this.mServer = server;
    }

    public Map<String, String> getQuery() {
        return this.mQuery;
    }

    public void write(String message) throws IOException {
        assert (this.mSession != null);
        this.mSession.getRemote().sendString(message);
    }

    public void write(byte[] message) throws IOException {
        assert (this.mSession != null);
        this.mSession.getRemote().sendBytes(ByteBuffer.wrap(message));
    }

    public void close() {
        if (this.mSession != null) {
            this.mSession.close();
        }
    }

    public void onWebSocketConnect(Session session) {
        this.mSession = session;
        this.mQuery = ParseQS.decode((String)session.getUpgradeRequest().getQueryString());
        this.mServer.handleWebSocket((EngineIoWebSocket)this);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.emit("close", new Object[0]);
        this.mSession = null;
    }

    public void onWebSocketError(Throwable cause) {
        this.emit("error", new Object[]{"write error", cause.getMessage()});
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        byte[] message;
        if (offset == 0 && len == payload.length) {
            message = payload;
        } else {
            message = new byte[len];
            System.arraycopy(payload, offset, message, 0, len);
        }
        this.emit("message", new Object[]{message});
    }

    public void onWebSocketText(String message) {
        this.emit("message", new Object[]{message});
    }
}

