/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.parser;

import io.socket.engineio.parser.Buffer;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServerParser {
    public static final int PROTOCOL = 3;
    private static final Map<String, Integer> packets = new HashMap<String, Integer>(){
        {
            this.put("open", 0);
            this.put("close", 1);
            this.put("ping", 2);
            this.put("pong", 3);
            this.put("message", 4);
            this.put("upgrade", 5);
            this.put("noop", 6);
        }
    };
    private static final Map<Integer, String> packetsList = new HashMap<Integer, String>();
    private static Packet<String> err;

    private ServerParser() {
    }

    public static void encodePacket(Packet packet, boolean supportsBinary, Parser.EncodeCallback callback) {
        if (packet.data instanceof byte[]) {
            ServerParser.encodeByteArray((Packet<byte[]>)packet, supportsBinary, callback);
        } else {
            String encoded = String.valueOf(packets.get(packet.type));
            if (null != packet.data) {
                encoded = encoded + String.valueOf(packet.data);
            }
            callback.call((Object)encoded);
        }
    }

    public static void encodePayload(List<Packet<?>> packets, boolean supportsBinary, Parser.EncodeCallback callback) {
        boolean isBinary = false;
        for (Packet<?> packet : packets) {
            if (!(packet.data instanceof byte[])) continue;
            isBinary = true;
            break;
        }
        if (isBinary && supportsBinary) {
            Parser.EncodeCallback _callback = callback;
            ServerParser.encodePayloadAsBinary(packets, (Parser.EncodeCallback<byte[]>)_callback);
            return;
        }
        if (packets.size() == 0) {
            callback.call((Object)"0:");
            return;
        }
        StringBuilder result = new StringBuilder();
        for (Packet<?> packet : packets) {
            ServerParser.encodePacket(packet, false, data -> result.append(ServerParser.setLengthHeader((String)data)));
        }
        callback.call((Object)result.toString());
    }

    public static void encodePayloadAsBinary(List<Packet<?>> packets, Parser.EncodeCallback<byte[]> callback) {
        if (packets.size() == 0) {
            callback.call((Object)new byte[0]);
            return;
        }
        ArrayList results = new ArrayList(packets.size());
        for (Packet<?> packet : packets) {
            ServerParser.encodePacket(packet, true, packet1 -> {
                if (packet1 instanceof String) {
                    String encodingLength = String.valueOf(((String)packet1).length());
                    byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                    sizeBuffer[0] = 0;
                    for (int i = 0; i < encodingLength.length(); ++i) {
                        sizeBuffer[i + 1] = (byte)Character.getNumericValue(encodingLength.charAt(i));
                    }
                    sizeBuffer[sizeBuffer.length - 1] = -1;
                    results.add(Buffer.concat((byte[][])new byte[][]{sizeBuffer, ((String)packet1).getBytes(StandardCharsets.UTF_8)}));
                } else {
                    String encodingLength = String.valueOf(((byte[])packet1).length);
                    byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                    sizeBuffer[0] = 1;
                    for (int i = 0; i < encodingLength.length(); ++i) {
                        sizeBuffer[i + 1] = (byte)Character.getNumericValue(encodingLength.charAt(i));
                    }
                    sizeBuffer[sizeBuffer.length - 1] = -1;
                    results.add(Buffer.concat((byte[][])new byte[][]{sizeBuffer, (byte[])packet1}));
                }
            });
        }
        callback.call((Object)Buffer.concat((byte[][])((byte[][])results.toArray((T[])new byte[results.size()][]))));
    }

    public static Packet decodePacket(Object data) {
        if (data == null) {
            return err;
        }
        if (data instanceof String) {
            String stringData = (String)data;
            if (stringData.charAt(0) == 'b') {
                Packet packet = new Packet(packetsList.get(Integer.parseInt(String.valueOf(stringData.charAt(1)))));
                packet.data = Base64.getDecoder().decode(stringData.substring(2));
                return packet;
            }
            Packet packet = new Packet(packetsList.get(Integer.parseInt(String.valueOf(stringData.charAt(0)))));
            packet.data = stringData.substring(1);
            return packet;
        }
        if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            Packet packet = new Packet(packetsList.get(byteData[0]));
            packet.data = new byte[byteData.length - 1];
            System.arraycopy(byteData, 1, packet.data, 0, ((byte[])packet.data).length);
            return packet;
        }
        throw new IllegalArgumentException("Invalid type for data: " + data.getClass().getSimpleName());
    }

    public static void decodePayload(Object data, Parser.DecodePayloadCallback callback) {
        int payloadIdx;
        assert (callback != null);
        ArrayList<Packet> packets = new ArrayList<Packet>();
        if (data instanceof String) {
            String stringData = (String)data;
            payloadIdx = 0;
            while (payloadIdx < stringData.length()) {
                int separatorIdx = stringData.indexOf(58, payloadIdx);
                if (separatorIdx < 0) {
                    throw new IllegalArgumentException("Invalid payload: " + stringData);
                }
                int length = Integer.parseInt(stringData.substring(payloadIdx, separatorIdx));
                String packetData = stringData.substring(separatorIdx + 1, length + separatorIdx + 1);
                Packet packet = ServerParser.decodePacket(packetData);
                packets.add(packet);
                payloadIdx = length + separatorIdx + 1;
            }
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            payloadIdx = 0;
            while (payloadIdx < byteData.length) {
                int lengthStartIdx;
                boolean isBinary = byteData[payloadIdx] == 1;
                int lengthEndIdx = lengthStartIdx = payloadIdx + 1;
                while (byteData[lengthEndIdx] != -1) {
                    ++lengthEndIdx;
                }
                StringBuilder lengthString = new StringBuilder();
                for (int l = lengthStartIdx; l < lengthEndIdx; ++l) {
                    char digit = (char)(48 + byteData[l]);
                    lengthString.append(digit);
                }
                int length = Integer.parseInt(lengthString.toString());
                byte[] bufferData = new byte[length];
                System.arraycopy(byteData, lengthEndIdx + 1, bufferData, 0, bufferData.length);
                Packet packet = isBinary ? ServerParser.decodePacket(bufferData) : ServerParser.decodePacket(new String(bufferData, StandardCharsets.UTF_8));
                packets.add(packet);
                payloadIdx = lengthEndIdx + length + 1;
            }
        }
        for (int i = 0; i < packets.size(); ++i) {
            if (callback.call((Packet)packets.get(i), i, packets.size())) continue;
            return;
        }
    }

    private static void encodeByteArray(Packet<byte[]> packet, boolean supportsBinary, Parser.EncodeCallback callback) {
        if (supportsBinary) {
            byte[] data = (byte[])packet.data;
            byte[] resultArray = new byte[1 + data.length];
            resultArray[0] = packets.get(packet.type).byteValue();
            System.arraycopy(data, 0, resultArray, 1, data.length);
            callback.call((Object)resultArray);
        } else {
            String resultBuilder = "b" + packets.get(packet.type).byteValue() + Base64.getEncoder().encodeToString((byte[])packet.data);
            callback.call((Object)resultBuilder);
        }
    }

    private static String setLengthHeader(String message) {
        return message.length() + ":" + message;
    }

    static {
        for (Map.Entry<String, Integer> entry : packets.entrySet()) {
            packetsList.put(entry.getValue(), entry.getKey());
        }
        err = new Packet("error", (Object)"parser error");
    }
}

