/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.engineio.parser.Packet;
import java.util.Arrays;
import java.util.Comparator;

public final class EngineIoServerOptions {
    public static final EngineIoServerOptions DEFAULT = new EngineIoServerOptions();
    public static final String[] ALLOWED_CORS_ORIGIN_ALL = null;
    public static final String[] ALLOWED_CORS_ORIGIN_NONE = new String[0];
    private boolean mIsLocked = false;
    private boolean mCorsHandlingDisabled;
    private long mPingInterval;
    private long mPingTimeout;
    private String[] mAllowedCorsOrigins;
    private Packet<Object> mInitialPacket;
    private int mMaxTimeoutThreadPoolSize;

    private EngineIoServerOptions() {
    }

    public static EngineIoServerOptions newFromDefault() {
        return new EngineIoServerOptions().setCorsHandlingDisabled(DEFAULT.isCorsHandlingDisabled()).setPingInterval(DEFAULT.getPingInterval()).setPingTimeout(DEFAULT.getPingTimeout()).setAllowedCorsOrigins(DEFAULT.getAllowedCorsOrigins()).setMaxTimeoutThreadPoolSize(DEFAULT.getMaxTimeoutThreadPoolSize()).setInitialPacket(null);
    }

    public boolean isCorsHandlingDisabled() {
        return this.mCorsHandlingDisabled;
    }

    public EngineIoServerOptions setCorsHandlingDisabled(boolean corsHandlingDisabled) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("CORS handling cannot be set. Instance is locked.");
        }
        this.mCorsHandlingDisabled = corsHandlingDisabled;
        return this;
    }

    public long getPingInterval() {
        return this.mPingInterval;
    }

    public EngineIoServerOptions setPingInterval(long pingInterval) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Ping interval cannot be set. Instance is locked.");
        }
        this.mPingInterval = pingInterval;
        return this;
    }

    public long getPingTimeout() {
        return this.mPingTimeout;
    }

    public EngineIoServerOptions setPingTimeout(long pingTimeout) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Ping timeout cannot be set. Instance is locked.");
        }
        this.mPingTimeout = pingTimeout;
        return this;
    }

    public String[] getAllowedCorsOrigins() {
        return this.mAllowedCorsOrigins;
    }

    public EngineIoServerOptions setAllowedCorsOrigins(String[] allowedCorsOrigins) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Allowed CORS origins cannot be set. Instance is locked.");
        }
        this.mAllowedCorsOrigins = null;
        if (allowedCorsOrigins != null) {
            this.mAllowedCorsOrigins = new String[allowedCorsOrigins.length];
            System.arraycopy(allowedCorsOrigins, 0, this.mAllowedCorsOrigins, 0, allowedCorsOrigins.length);
            Arrays.sort(this.mAllowedCorsOrigins, Comparator.naturalOrder());
        }
        return this;
    }

    public Packet<?> getInitialPacket() {
        return this.mInitialPacket;
    }

    public EngineIoServerOptions setInitialPacket(Packet<?> initialPacket) throws IllegalStateException, IllegalArgumentException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Initial packet cannot be set. Instance is locked.");
        }
        if (initialPacket != null) {
            if (initialPacket.type == null || !initialPacket.type.equals("message")) {
                throw new IllegalArgumentException("Initial packet must be a message packet.");
            }
            if (initialPacket.data == null) {
                throw new IllegalArgumentException("Initial packet data must not be null.");
            }
        }
        this.mInitialPacket = null;
        if (initialPacket != null) {
            this.mInitialPacket = new Packet(initialPacket.type);
            this.mInitialPacket.data = initialPacket.data;
        }
        return this;
    }

    public void lock() {
        this.mIsLocked = true;
    }

    public int getMaxTimeoutThreadPoolSize() {
        return this.mMaxTimeoutThreadPoolSize;
    }

    public EngineIoServerOptions setMaxTimeoutThreadPoolSize(int maxTimeoutThreadPoolSize) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Max timeout thread pool size cannot be set. Instance is locked.");
        }
        this.mMaxTimeoutThreadPoolSize = maxTimeoutThreadPoolSize;
        return this;
    }

    static {
        DEFAULT.setCorsHandlingDisabled(false);
        DEFAULT.setPingTimeout(5000L);
        DEFAULT.setPingInterval(25000L);
        DEFAULT.setAllowedCorsOrigins(ALLOWED_CORS_ORIGIN_ALL);
        DEFAULT.setMaxTimeoutThreadPoolSize(20);
        DEFAULT.lock();
    }
}

