/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.engineio.server.Emitter;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.engineio.server.EngineIoSocket;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.ServerErrors;
import io.socket.engineio.server.Transport;
import io.socket.engineio.server.parser.Parser;
import io.socket.engineio.server.transport.Polling;
import io.socket.engineio.server.transport.WebSocket;
import io.socket.engineio.server.utils.JsonUtils;
import io.socket.engineio.server.utils.ParseQS;
import io.socket.engineio.server.utils.ServerYeast;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class EngineIoServer
extends Emitter {
    private static final String ERROR_JSON = "{\"code\": %d, \"message\": \"%s\"}";
    private final Map<String, EngineIoSocket> mClients = new ConcurrentHashMap<String, EngineIoSocket>();
    private final EngineIoServerOptions mOptions;
    private final HashSet<String> mAllowedCorsOrigins;
    private final ScheduledExecutorService mScheduledExecutor;
    private final HandshakeInterceptor mHandshakeInterceptor;

    public EngineIoServer() {
        this(EngineIoServerOptions.DEFAULT);
    }

    public EngineIoServer(EngineIoServerOptions options) {
        this.mOptions = options;
        this.mOptions.lock();
        if (options.getAllowedCorsOrigins() != null) {
            this.mAllowedCorsOrigins = new HashSet();
            for (String origin : options.getAllowedCorsOrigins()) {
                if (origin == null) continue;
                this.mAllowedCorsOrigins.add(origin.toLowerCase(Locale.getDefault()));
            }
        } else {
            this.mAllowedCorsOrigins = null;
        }
        this.mScheduledExecutor = this.mOptions.getScheduledExecutorService() != null ? this.mOptions.getScheduledExecutorService() : Executors.newScheduledThreadPool(this.mOptions.getMaxTimeoutThreadPoolSize(), new ThreadFactory(){
            private final AtomicLong mThreadCount = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format("engineIo-threadPool-%d", this.mThreadCount.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            }
        });
        this.mHandshakeInterceptor = this.mOptions.getHandshakeInterceptor();
    }

    public EngineIoServerOptions getOptions() {
        return this.mOptions;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.mScheduledExecutor;
    }

    public void shutdown() {
        if (this.mOptions.getScheduledExecutorService() == null) {
            this.mScheduledExecutor.shutdownNow();
        }
        this.mClients.clear();
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String transport;
        Map<String, String> query = ParseQS.decode(request.getQueryString());
        request.setAttribute("query", query);
        if (!this.mOptions.isCorsHandlingDisabled()) {
            boolean sendCors;
            String origin = request.getHeader("Origin");
            boolean bl = sendCors = origin != null && (this.mAllowedCorsOrigins == null || this.mAllowedCorsOrigins.contains(origin.toLowerCase(Locale.getDefault())));
            if (sendCors) {
                response.addHeader("Access-Control-Allow-Origin", origin);
                response.addHeader("Access-Control-Allow-Credentials", "true");
                response.addHeader("Access-Control-Allow-Methods", "GET,HEAD,PUT,PATCH,POST,DELETE");
                response.addHeader("Access-Control-Allow-Headers", "origin, content-type, accept");
            }
        }
        if ((transport = query.get("transport")) == null || !transport.equals("polling")) {
            this.sendErrorMessage(response, ServerErrors.UNKNOWN_TRANSPORT);
            return;
        }
        if (!request.isAsyncSupported() && !this.mOptions.isSyncPollingAllowed()) {
            this.sendErrorMessage(response, ServerErrors.FORBIDDEN);
            return;
        }
        String sid = query.get("sid");
        if (sid != null) {
            EngineIoSocket client = this.mClients.get(sid);
            if (client == null) {
                this.sendErrorMessage(response, ServerErrors.UNKNOWN_SID);
            } else if (!transport.equals(client.getCurrentTransportName())) {
                this.sendErrorMessage(response, ServerErrors.BAD_REQUEST);
            } else {
                client.onRequest(request, response);
            }
        } else if (!request.getMethod().equalsIgnoreCase("GET")) {
            this.sendErrorMessage(response, ServerErrors.BAD_HANDSHAKE_METHOD);
        } else if (this.mHandshakeInterceptor != null) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Enumeration headerNamesEnum = request.getHeaderNames();
            while (headerNamesEnum.hasMoreElements()) {
                String headerName = (String)headerNamesEnum.nextElement();
                headers.put(headerName, Collections.list(request.getHeaders(headerName)));
            }
            if (this.mHandshakeInterceptor.intercept(query, headers)) {
                this.handshakePolling(request, response);
            } else {
                this.sendErrorMessage(response, ServerErrors.BAD_REQUEST);
            }
        } else {
            this.handshakePolling(request, response);
        }
    }

    public void handleWebSocket(EngineIoWebSocket webSocket) {
        Map<String, String> query = webSocket.getQuery();
        String sid = query.get("sid");
        if (sid != null) {
            EngineIoSocket socket = this.mClients.get(sid);
            if (socket == null) {
                webSocket.close();
            } else if (!socket.canUpgrade("websocket")) {
                webSocket.close();
            } else {
                WebSocket transport = new WebSocket(webSocket, EngineIoServer.parserFromQuery(webSocket.getQuery()));
                socket.upgrade(transport);
            }
        } else if (this.mHandshakeInterceptor == null || this.mHandshakeInterceptor.intercept(webSocket.getQuery(), webSocket.getConnectionHeaders())) {
            this.handshakeWebSocket(webSocket);
        } else {
            webSocket.close();
        }
    }

    private void sendErrorMessage(HttpServletResponse response, ServerErrors code) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (code != null) {
            response.setStatus(400);
            response.getWriter().write(String.format(ERROR_JSON, code.getCode(), JsonUtils.escape(code.getMessage())));
        } else {
            response.setStatus(403);
            response.getWriter().write(String.format(ERROR_JSON, ServerErrors.FORBIDDEN.getCode(), JsonUtils.escape(ServerErrors.FORBIDDEN.getMessage())));
        }
    }

    private void handshakePolling(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sid = ServerYeast.yeast();
        Object lockObject = new Object();
        Parser parser = EngineIoServer.parserFromQuery((Map)request.getAttribute("query"));
        EngineIoSocket socket = new EngineIoSocket(lockObject, sid, parser.getProtocolVersion(), this, this.mScheduledExecutor);
        Polling transport = new Polling(lockObject, parser);
        socket.init(transport);
        ((Transport)transport).onRequest(request, response);
        socket.updateInitialHeadersFromActiveTransport();
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", socket);
    }

    private void handshakeWebSocket(EngineIoWebSocket webSocket) {
        String sid = ServerYeast.yeast();
        Parser parser = EngineIoServer.parserFromQuery(webSocket.getQuery());
        WebSocket transport = new WebSocket(webSocket, parser);
        EngineIoSocket socket = new EngineIoSocket(new Object(), sid, parser.getProtocolVersion(), this, this.mScheduledExecutor);
        socket.init(transport);
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", socket);
    }

    private static Parser parserFromQuery(Map<String, String> query) {
        return query != null && query.containsKey("EIO") && query.get("EIO").equals("4") ? Parser.PROTOCOL_V4 : Parser.PROTOCOL_V3;
    }

    public static interface HandshakeInterceptor {
        public boolean intercept(Map<String, String> var1, Map<String, List<String>> var2);
    }
}

