/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.utils;

import java.util.Arrays;
import java.util.Locale;

public interface JsonUtils {
    public static final String[] REPLACEMENTS = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\u0009", "\\u000A", "\\u000B", "\\u000C", "\\u000D", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F", null, null, "\\\"", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "\\\\", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    public static final String EMPTY_ARRAY = "[]";

    public static String toJson(String[] array) {
        if (array.length <= 0) {
            return EMPTY_ARRAY;
        }
        return '[' + String.join((CharSequence)",", (CharSequence[])Arrays.stream(array).map(s -> "\"" + JsonUtils.escape(s) + "\"").toArray(String[]::new)) + ']';
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch < '\u0080') {
                String replacement = REPLACEMENTS[ch];
                if (replacement != null) {
                    sb.append(replacement);
                    continue;
                }
            } else if (ch < '\u0100') {
                sb.append("\\u00").append(Integer.toHexString(ch).toLowerCase(Locale.ROOT));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

