/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.socketio.server.parser.Packet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class PacketUtils {
    private static final Object[] EMPTY_ARGS = new Object[0];

    PacketUtils() {
    }

    static Packet<?> createDataPacket(int type, String event, Object[] args) throws IllegalArgumentException {
        if (args == null) {
            args = EMPTY_ARGS;
        }
        JSONArray array = new JSONArray();
        if (event != null) {
            array.put((Object)event);
        }
        for (Object arg : args) {
            array.put(arg);
        }
        if (!PacketUtils.isPacketDataValid(array)) {
            throw new IllegalArgumentException("args contain invalid data type.");
        }
        Packet packet = new Packet();
        packet.type = type;
        packet.data = array;
        return packet;
    }

    private static boolean isPacketDataValid(JSONArray array) {
        try {
            for (int idx = 0; idx < array.length(); ++idx) {
                Object item = array.get(idx);
                if (!PacketUtils.isPacketDataValidType(item)) {
                    return false;
                }
                if (item == null) {
                    array.put(idx, JSONObject.NULL);
                }
                if (item instanceof JSONArray && !PacketUtils.isPacketDataValid((JSONArray)item)) {
                    return false;
                }
                if (!(item instanceof JSONObject) || PacketUtils.isPacketDataValid((JSONObject)item)) continue;
                return false;
            }
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private static boolean isPacketDataValid(JSONObject object) {
        try {
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                Object keyObj = keys.next();
                if (!(keyObj instanceof String)) {
                    return false;
                }
                String key = (String)keyObj;
                Object item = object.get(key);
                if (!PacketUtils.isPacketDataValidType(item)) {
                    return false;
                }
                if (item == null) {
                    object.put(key, JSONObject.NULL);
                }
                if (item instanceof JSONArray && !PacketUtils.isPacketDataValid((JSONArray)item)) {
                    return false;
                }
                if (!(item instanceof JSONObject) || PacketUtils.isPacketDataValid((JSONObject)item)) continue;
                return false;
            }
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private static boolean isPacketDataValidType(Object object) {
        return object == null || object == JSONObject.NULL || object instanceof JSONObject || object instanceof JSONArray || object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof byte[];
    }
}

