/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.commons;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public final class IdGenerator {
    private IdGenerator() {
    }

    public static String shortUUID() {
        return IdGenerator.shortUUID("");
    }

    public static String shortUUID(String prefix) {
        UUID uuid = UUID.randomUUID();
        long l = ByteBuffer.wrap(uuid.toString().getBytes()).getLong();
        return IdGenerator.prefix(Long.toString(l, 36), prefix);
    }

    public static String secureRandomId() {
        return IdGenerator.secureRandomId("");
    }

    public static String secureRandomId(String prefix) {
        return IdGenerator.prefix(NanoIdUtils.randomNanoId(), prefix);
    }

    private static String prefix(String value, String prefix) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return value;
        }
        String prefix2 = prefix.trim().toLowerCase();
        boolean hasNoDelimier = prefix2.matches(".*[a-zA-Z]$");
        if (hasNoDelimier) {
            return prefix2 + "_" + value;
        }
        return prefix2 + value;
    }
}

