/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.commons;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static byte[] serialize(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof Optional) {
            Optional opt = (Optional)input;
            return opt.map(ObjectUtil::serialize).orElse(null);
        }
        return JsonStream.serialize((Object)input).getBytes(StandardCharsets.UTF_8);
    }

    public static <T> T deserialize(byte[] input, Class<T> type) {
        if (input == null || input.length == 0) {
            return null;
        }
        return (T)JsonIterator.deserialize((byte[])input, type);
    }

    public static <T> T clone(T input) {
        return (T)ObjectUtil.deserialize(ObjectUtil.serialize(input), input.getClass());
    }
}

