/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.context;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.soffa.foundation.commons.TextUtil;
import io.soffa.foundation.model.Authentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class RequestContext {
    private static String serviceName = "app";
    private String authorization;
    private String tenantId;
    private String applicationName;
    private String sender;
    private String traceId = UUID.randomUUID().toString();
    private String spanId = UUID.randomUUID().toString();
    @JsonIgnore
    private transient Authentication authentication;

    public RequestContext() {
        this.sender = serviceName;
    }

    public static RequestContext create(String tenantId) {
        return new RequestContext().withTenant(tenantId);
    }

    public boolean hasAuthorization() {
        return this.authorization != null && !this.authorization.isEmpty();
    }

    public static void setServiceName(String value) {
        if (TextUtil.isEmpty(value)) {
            throw new IllegalArgumentException("Service name cannot be empty");
        }
        serviceName = value;
    }

    public String getSender() {
        return this.sender;
    }

    public RequestContext withTenant(String tenantId) {
        this.setTenantId(tenantId);
        return this;
    }

    public RequestContext withAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public String getTenant() {
        if (this.tenantId == null) {
            return null;
        }
        return this.tenantId;
    }

    public boolean hasTenant() {
        return this.tenantId != null && !this.tenantId.isEmpty();
    }

    public boolean isAuthenticated() {
        return this.authentication != null;
    }

    public void setAuthentication(Authentication auth) {
        this.authentication = auth;
        if (auth == null) {
            return;
        }
        this.tenantId = auth.getTenantId();
        if (auth.getApplication() != null && !auth.getApplication().isEmpty()) {
            this.applicationName = auth.getApplication();
        }
    }

    public Optional<String> getUsername() {
        if (this.authentication != null) {
            return Optional.ofNullable(this.authentication.getUsername());
        }
        return Optional.empty();
    }

    public void sync() {
        this.sender = serviceName;
    }

    public Map<String, String> getContextMap() {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        if (TextUtil.isNotEmpty(this.getApplicationName())) {
            contextMap.put("application", this.getApplicationName());
        }
        if (TextUtil.isNotEmpty(this.getTenant())) {
            contextMap.put("tenant", this.getTenant());
        }
        if (TextUtil.isNotEmpty(this.getTraceId())) {
            contextMap.put("traceId", this.getTraceId());
        }
        if (TextUtil.isNotEmpty(this.getSpanId())) {
            contextMap.put("spanId", this.getSpanId());
        }
        if (TextUtil.isNotEmpty(this.getSender())) {
            contextMap.put("sender", this.getSender());
        }
        if (this.getAuthentication() != null && TextUtil.isNotEmpty(this.getAuthentication().getUsername())) {
            contextMap.put("user", this.getAuthentication().getUsername());
        }
        contextMap.put("service_name", serviceName);
        return contextMap;
    }

    public static RequestContext fromHeaders(Map<String, String> headers) {
        RequestContext context = new RequestContext();
        if (headers == null) {
            return context;
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            String value = e.getValue();
            if (TextUtil.isEmpty(value)) continue;
            String key = e.getKey();
            if (key.equalsIgnoreCase("X-Application")) {
                context.setApplicationName(value);
                continue;
            }
            if (key.equalsIgnoreCase("X-TenantId")) {
                context.setTenantId(value);
                continue;
            }
            if (key.equalsIgnoreCase("X-SpanId")) {
                context.setTraceId(value);
                continue;
            }
            if (key.equalsIgnoreCase("X-TraceId")) {
                context.setSpanId(value);
                continue;
            }
            if (key.equalsIgnoreCase("X-ServiceName")) {
                context.setSender(value);
                continue;
            }
            if (!key.equalsIgnoreCase("Authorization")) continue;
            context.setAuthorization(value);
        }
        return context;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (TextUtil.isNotEmpty(this.getApplicationName())) {
            headers.put("X-Application", this.getApplicationName());
        }
        if (TextUtil.isNotEmpty(this.getTenant())) {
            headers.put("X-TenantId", this.getTenant());
        }
        if (TextUtil.isNotEmpty(this.getTraceId())) {
            headers.put("X-TraceId", this.getTraceId());
        }
        if (TextUtil.isNotEmpty(this.getSpanId())) {
            headers.put("X-SpanId", this.getSpanId());
        }
        if (TextUtil.isNotEmpty(this.getSender())) {
            headers.put("X-ServiceName", this.getSender());
        }
        if (TextUtil.isNotEmpty(this.getAuthorization())) {
            headers.put("Authorization", this.getAuthorization());
        }
        return headers;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestContext)) {
            return false;
        }
        RequestContext other = (RequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$spanId = this.getSpanId();
        String other$spanId = other.getSpanId();
        return !(this$spanId == null ? other$spanId != null : !this$spanId.equals(other$spanId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $spanId = this.getSpanId();
        result = result * 59 + ($spanId == null ? 43 : $spanId.hashCode());
        return result;
    }

    public String toString() {
        return "RequestContext(authorization=" + this.getAuthorization() + ", tenantId=" + this.getTenantId() + ", applicationName=" + this.getApplicationName() + ", sender=" + this.getSender() + ", traceId=" + this.getTraceId() + ", spanId=" + this.getSpanId() + ", authentication=" + this.getAuthentication() + ")";
    }
}

