/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.errors;

import com.mgnt.utils.TextUtils;
import io.soffa.foundation.commons.TextUtil;
import io.soffa.foundation.errors.ConflictException;
import io.soffa.foundation.errors.ForbiddenException;
import io.soffa.foundation.errors.FunctionalException;
import io.soffa.foundation.errors.InvalidAuthException;
import io.soffa.foundation.errors.InvalidTenantException;
import io.soffa.foundation.errors.InvalidTokenException;
import io.soffa.foundation.errors.NoContentException;
import io.soffa.foundation.errors.ResourceNotFoundException;
import io.soffa.foundation.errors.TechnicalException;
import io.soffa.foundation.errors.TimeoutException;
import io.soffa.foundation.errors.TodoException;
import io.soffa.foundation.errors.UnauthorizedException;
import io.soffa.foundation.errors.ValidationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ErrorUtil {
    private static final String ALL_PACKAGES = "*";
    private static String defaultErrorPackage = "io.soffa";
    private static final Map<Class<?>, Integer> MAPPED_STATUS = new LinkedHashMap();

    private ErrorUtil() {
        TextUtils.setRelevantPackage((String)defaultErrorPackage);
    }

    public static void setRelevantPackage(String pkg) {
        defaultErrorPackage = pkg;
        if (!ALL_PACKAGES.equals(pkg)) {
            TextUtils.setRelevantPackage((String)pkg);
        }
    }

    public static String getStacktrace(Throwable e) {
        if (ALL_PACKAGES.equals(defaultErrorPackage)) {
            return TextUtils.getStacktrace((Throwable)e, (boolean)true);
        }
        return TextUtils.getStacktrace((Throwable)e, (boolean)true, (String)defaultErrorPackage);
    }

    public static Throwable unwrap(Throwable error) {
        if (error instanceof InvocationTargetException && error.getCause() != null) {
            return ErrorUtil.unwrap(error.getCause());
        }
        if (error instanceof UndeclaredThrowableException && error.getCause() != null) {
            return ErrorUtil.unwrap(error.getCause());
        }
        if (error instanceof RuntimeException && error.getCause() != null) {
            return ErrorUtil.unwrap(error.getCause());
        }
        return error;
    }

    public static String loookupOriginalMessage(Throwable error) {
        return ErrorUtil.loookupOriginalMessage(error, null);
    }

    public static String loookupOriginalMessage(Throwable error, Class<?> lookup) {
        if (error == null) {
            return "Unknown error";
        }
        if (lookup != null && lookup.isInstance(error)) {
            if (TextUtil.isEmpty(error.getMessage())) {
                return ErrorUtil.loookupOriginalMessage(error.getCause(), lookup);
            }
            return error.getMessage();
        }
        if (error.getCause() != null) {
            return ErrorUtil.loookupOriginalMessage(error.getCause(), lookup);
        }
        if (TextUtil.isEmpty(error.getMessage())) {
            return ErrorUtil.loookupOriginalMessage(error.getCause(), lookup);
        }
        return error.getMessage();
    }

    public static Exception getException(int errorCode, String message) {
        switch (errorCode) {
            case 400: {
                return new FunctionalException(message, new Object[0]);
            }
            case 409: {
                return new ConflictException(message, new Object[0]);
            }
            case 403: {
                return new ForbiddenException(message, new Object[0]);
            }
            case 401: {
                return new UnauthorizedException(message, new Object[0]);
            }
            case 408: {
                return new TimeoutException(message, new Object[0]);
            }
        }
        return new TechnicalException(message, new Object[0]);
    }

    public static int resolveErrorCode(Throwable e) {
        if (e == null) {
            return -1;
        }
        for (Map.Entry<Class<?>, Integer> entry : MAPPED_STATUS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(e.getClass())) continue;
            return entry.getValue();
        }
        return -1;
    }

    static {
        MAPPED_STATUS.put(InvalidTenantException.class, 400);
        MAPPED_STATUS.put(ValidationException.class, 400);
        MAPPED_STATUS.put(ConflictException.class, 409);
        MAPPED_STATUS.put(ForbiddenException.class, 403);
        MAPPED_STATUS.put(UnauthorizedException.class, 401);
        MAPPED_STATUS.put(InvalidTokenException.class, 401);
        MAPPED_STATUS.put(InvalidAuthException.class, 401);
        MAPPED_STATUS.put(ResourceNotFoundException.class, 404);
        MAPPED_STATUS.put(NoContentException.class, 204);
        MAPPED_STATUS.put(TodoException.class, 501);
        MAPPED_STATUS.put(SocketException.class, 408);
        MAPPED_STATUS.put(TimeoutException.class, 408);
    }
}

