/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.model;

import io.soffa.foundation.model.UserInfo;
import java.util.Map;
import java.util.Set;

public class Authentication {
    private String application;
    private String userId;
    private String username;
    private UserInfo profile;
    private String tenantId;
    private Set<String> roles;
    private Set<String> groups;
    private Set<String> permissions;
    private Map<String, Object> claims;
    private Map<String, Object> originalClaims;
    private Object principal;
    private boolean liveMode;

    public boolean hasPermission(String id) {
        return this.permissions != null && this.permissions.contains(id);
    }

    public static AuthenticationBuilder builder() {
        return new AuthenticationBuilder();
    }

    public Authentication() {
    }

    public Authentication(String application, String userId, String username, UserInfo profile, String tenantId, Set<String> roles, Set<String> groups, Set<String> permissions, Map<String, Object> claims, Map<String, Object> originalClaims, Object principal, boolean liveMode) {
        this.application = application;
        this.userId = userId;
        this.username = username;
        this.profile = profile;
        this.tenantId = tenantId;
        this.roles = roles;
        this.groups = groups;
        this.permissions = permissions;
        this.claims = claims;
        this.originalClaims = originalClaims;
        this.principal = principal;
        this.liveMode = liveMode;
    }

    public String getApplication() {
        return this.application;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public UserInfo getProfile() {
        return this.profile;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public Map<String, Object> getOriginalClaims() {
        return this.originalClaims;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isLiveMode() {
        return this.liveMode;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setProfile(UserInfo profile) {
        this.profile = profile;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public void setOriginalClaims(Map<String, Object> originalClaims) {
        this.originalClaims = originalClaims;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public void setLiveMode(boolean liveMode) {
        this.liveMode = liveMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authentication)) {
            return false;
        }
        Authentication other = (Authentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLiveMode() != other.isLiveMode()) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UserInfo this$profile = this.getProfile();
        UserInfo other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Set<String> this$permissions = this.getPermissions();
        Set<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        Map<String, Object> this$claims = this.getClaims();
        Map<String, Object> other$claims = other.getClaims();
        if (this$claims == null ? other$claims != null : !((Object)this$claims).equals(other$claims)) {
            return false;
        }
        Map<String, Object> this$originalClaims = this.getOriginalClaims();
        Map<String, Object> other$originalClaims = other.getOriginalClaims();
        if (this$originalClaims == null ? other$originalClaims != null : !((Object)this$originalClaims).equals(other$originalClaims)) {
            return false;
        }
        Object this$principal = this.getPrincipal();
        Object other$principal = other.getPrincipal();
        return !(this$principal == null ? other$principal != null : !this$principal.equals(other$principal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Authentication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLiveMode() ? 79 : 97);
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UserInfo $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Set<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        Map<String, Object> $claims = this.getClaims();
        result = result * 59 + ($claims == null ? 43 : ((Object)$claims).hashCode());
        Map<String, Object> $originalClaims = this.getOriginalClaims();
        result = result * 59 + ($originalClaims == null ? 43 : ((Object)$originalClaims).hashCode());
        Object $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        return result;
    }

    public String toString() {
        return "Authentication(application=" + this.getApplication() + ", userId=" + this.getUserId() + ", username=" + this.getUsername() + ", profile=" + this.getProfile() + ", tenantId=" + this.getTenantId() + ", roles=" + this.getRoles() + ", groups=" + this.getGroups() + ", permissions=" + this.getPermissions() + ", claims=" + this.getClaims() + ", originalClaims=" + this.getOriginalClaims() + ", principal=" + this.getPrincipal() + ", liveMode=" + this.isLiveMode() + ")";
    }

    public static class AuthenticationBuilder {
        private String application;
        private String userId;
        private String username;
        private UserInfo profile;
        private String tenantId;
        private Set<String> roles;
        private Set<String> groups;
        private Set<String> permissions;
        private Map<String, Object> claims;
        private Map<String, Object> originalClaims;
        private Object principal;
        private boolean liveMode;

        AuthenticationBuilder() {
        }

        public AuthenticationBuilder application(String application) {
            this.application = application;
            return this;
        }

        public AuthenticationBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AuthenticationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AuthenticationBuilder profile(UserInfo profile) {
            this.profile = profile;
            return this;
        }

        public AuthenticationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AuthenticationBuilder roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public AuthenticationBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        public AuthenticationBuilder permissions(Set<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public AuthenticationBuilder claims(Map<String, Object> claims) {
            this.claims = claims;
            return this;
        }

        public AuthenticationBuilder originalClaims(Map<String, Object> originalClaims) {
            this.originalClaims = originalClaims;
            return this;
        }

        public AuthenticationBuilder principal(Object principal) {
            this.principal = principal;
            return this;
        }

        public AuthenticationBuilder liveMode(boolean liveMode) {
            this.liveMode = liveMode;
            return this;
        }

        public Authentication build() {
            return new Authentication(this.application, this.userId, this.username, this.profile, this.tenantId, this.roles, this.groups, this.permissions, this.claims, this.originalClaims, this.principal, this.liveMode);
        }

        public String toString() {
            return "Authentication.AuthenticationBuilder(application=" + this.application + ", userId=" + this.userId + ", username=" + this.username + ", profile=" + this.profile + ", tenantId=" + this.tenantId + ", roles=" + this.roles + ", groups=" + this.groups + ", permissions=" + this.permissions + ", claims=" + this.claims + ", originalClaims=" + this.originalClaims + ", principal=" + this.principal + ", liveMode=" + this.liveMode + ")";
        }
    }
}

