/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.soffa.foundation.commons.IdGenerator;
import io.soffa.foundation.commons.ObjectUtil;
import io.soffa.foundation.commons.TextUtil;
import io.soffa.foundation.context.RequestContext;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class Message
implements Serializable {
    public static final long serialVersionUID = -2355203729601016346L;
    private String id;
    private String operation;
    private byte[] payload;
    private String payloadType;
    private Map<String, String> headers;

    public Message(String operation, RequestContext context) {
        this(null, operation, null, null, context);
    }

    public Message(String operation, Object payload, RequestContext context) {
        this(null, operation, payload, null, context);
    }

    public Message(String id, String operation, Object payload, String payloadType, RequestContext context) {
        this.id = TextUtil.isEmpty(id) ? IdGenerator.shortUUID("msg_") : id;
        this.operation = operation;
        this.payloadType = payloadType;
        if (context != null) {
            this.headers = context.getHeaders();
        }
        if (payload != null) {
            if (payload instanceof byte[]) {
                this.payload = (byte[])payload;
            } else {
                this.payload = ObjectUtil.serialize(payload);
                this.payloadType = payload.getClass().getName();
            }
        }
    }

    @JsonIgnore
    @Transient
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public RequestContext getContext() {
        return RequestContext.fromHeaders(this.headers);
    }

    public String getId() {
        return this.id;
    }

    public String getOperation() {
        return this.operation;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setPayloadType(String payloadType) {
        this.payloadType = payloadType;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        String this$payloadType = this.getPayloadType();
        String other$payloadType = other.getPayloadType();
        if (this$payloadType == null ? other$payloadType != null : !this$payloadType.equals(other$payloadType)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        String $payloadType = this.getPayloadType();
        result = result * 59 + ($payloadType == null ? 43 : $payloadType.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "Message(id=" + this.getId() + ", operation=" + this.getOperation() + ", payload=" + Arrays.toString(this.getPayload()) + ", payloadType=" + this.getPayloadType() + ", headers=" + this.getHeaders() + ")";
    }

    public Message(String id, String operation, byte[] payload, String payloadType, Map<String, String> headers) {
        this.id = id;
        this.operation = operation;
        this.payload = payload;
        this.payloadType = payloadType;
        this.headers = headers;
    }

    public Message() {
    }
}

