/*
 * Decompiled with CFR 0.152.
 */
package io.soffa.foundation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.soffa.foundation.commons.ObjectUtil;
import io.soffa.foundation.commons.TextUtil;
import io.soffa.foundation.errors.ErrorUtil;
import java.util.Arrays;

public class OperationResult {
    private Integer errorCode;
    private String error;
    private byte[] data;

    @JsonIgnore
    public boolean hasError() {
        return TextUtil.isNotEmpty(this.error);
    }

    public boolean isSuccess() {
        return !this.hasError();
    }

    public static OperationResult create(Object payload, Exception e) {
        OperationResult response = new OperationResult();
        if (e != null) {
            response.setErrorCode(ErrorUtil.resolveErrorCode(e));
            response.setError(e.getMessage());
        }
        response.setData(ObjectUtil.serialize(payload));
        return response;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getError() {
        return this.error;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "OperationResult(errorCode=" + this.getErrorCode() + ", error=" + this.getError() + ", data=" + Arrays.toString(this.getData()) + ")";
    }
}

