/*
 * Decompiled with CFR 0.152.
 */
package io.softwarity.lib.ldap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public class LdapConfiguration {
    private String uri;
    private String bindDN;
    private String baseDN;
    private boolean zz;
    private String filter;
    private String cert;
    private boolean ignoreCertHostname = false;

    public void setCertFromResource(String resourceName) {
        try (InputStream inputStream = LdapConfiguration.class.getClassLoader().getResourceAsStream(resourceName);){
            this.setCertFromInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCertFromFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.setCertFromInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCertFromInputStream(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            this.cert = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public boolean isZz() {
        return this.zz;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getCert() {
        return this.cert;
    }

    public boolean isIgnoreCertHostname() {
        return this.ignoreCertHostname;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public void setZz(boolean zz) {
        this.zz = zz;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public void setIgnoreCertHostname(boolean ignoreCertHostname) {
        this.ignoreCertHostname = ignoreCertHostname;
    }

    public String toString() {
        return "LdapConfiguration(uri=" + this.getUri() + ", bindDN=" + this.getBindDN() + ", baseDN=" + this.getBaseDN() + ", zz=" + this.isZz() + ", filter=" + this.getFilter() + ", cert=" + this.getCert() + ", ignoreCertHostname=" + this.isIgnoreCertHostname() + ")";
    }
}

