/*
 * Decompiled with CFR 0.152.
 */
package io.softwarity.lib.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(LdapSSLSocketFactory.class);
    private SSLSocketFactory socketFactory;
    private static Map<String, String> certs = new HashMap<String, String>();

    public static void addCert(String alias, String cert) {
        certs.put(alias, cert);
    }

    public LdapSSLSocketFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            certs.entrySet().forEach(entry -> {
                block7: {
                    try {
                        if (!Objects.nonNull(entry.getValue())) break block7;
                        try (ByteArrayInputStream certIn = new ByteArrayInputStream(((String)entry.getValue()).getBytes());){
                            keyStore.setCertificateEntry((String)entry.getKey(), CertificateFactory.getInstance("X.509").generateCertificate(certIn));
                        }
                    }
                    catch (Exception ex) {
                        log.warn(ex.getMessage(), (Throwable)ex);
                    }
                }
            });
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    public static SocketFactory getDefault() {
        return new LdapSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean bln) throws IOException {
        return this.socketFactory.createSocket(socket, host, port, bln);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress ia, int i1) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, ia, i1);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i) throws IOException {
        return this.socketFactory.createSocket(ia, i);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
        return this.socketFactory.createSocket(ia, i, ia1, i1);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }
}

