/*
 * Decompiled with CFR 0.152.
 */
package io.softwarity.lib.ldap;

import io.softwarity.lib.ldap.IgnoreHostNameVerifier;
import io.softwarity.lib.ldap.LdapResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSearch {
    private static final Logger log = LoggerFactory.getLogger(LdapSearch.class);
    String GROUPS_FILTER = "(|(objectClass=groupOfNames)(objectClass=groupOfUniqueNames)(objectClass=group))";

    public InitialLdapContext initContext(String url) throws NamingException {
        log.debug("Connection to LDAP server - URL: {}", (Object)url);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.referral", "follow");
        InitialLdapContext context = new InitialLdapContext(env, null);
        return context;
    }

    public StartTlsResponse addZZOption(InitialLdapContext context, String cert, boolean ignoreCertHostname) throws IOException, NamingException {
        StartTlsResponse tls = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
        try {
            SSLContext sslContext = this.getSSLContext(cert);
            if (ignoreCertHostname) {
                tls.setHostnameVerifier(new IgnoreHostNameVerifier());
            }
            tls.negotiate(sslContext.getSocketFactory());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return tls;
    }

    public void connect(InitialLdapContext context, String login, String password) throws NamingException {
        context.addToEnvironment("java.naming.security.authentication", "simple");
        context.addToEnvironment("java.naming.security.principal", login);
        context.addToEnvironment("java.naming.security.credentials", password);
    }

    public LdapResult search(DirContext context, String D, String b, String filter, String login) throws NamingException {
        LdapResult ldapResult = new LdapResult();
        SearchControls searchControls = this.getSearchControls(new String[]{"*", "memberOf"});
        NamingEnumeration<SearchResult> results = context.search(b, filter, (Object[])new String[]{login}, searchControls);
        boolean cont = true;
        while (cont && results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (!result.getNameInNamespace().matches(String.format("^\\w{2,3}=%s,.*", login))) continue;
            cont = false;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!ldapResult.containsKey(attr.getID())) {
                    ldapResult.put(attr.getID(), new ArrayList());
                }
                if (attr.getID().equalsIgnoreCase("memberOf")) {
                    HashSet<String> allGroups = new HashSet<String>();
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMore()) {
                        String groupDn = (String)e.next();
                        allGroups.add(groupDn);
                        this.findNestedGroupsBasedOn(context, groupDn, allGroups);
                    }
                    ((Collection)ldapResult.get("memberOf")).addAll(allGroups);
                    continue;
                }
                ((Collection)ldapResult.get(attr.getID())).add(attr.get().toString());
            }
        }
        return ldapResult;
    }

    private void findNestedGroupsBasedOn(DirContext ctx, String groupDn, Set<String> allGroups) {
        SearchControls searchControls = this.getSearchControls(new String[]{"*", "memberOf"});
        try {
            NamingEnumeration<SearchResult> results = ctx.search(groupDn, this.GROUPS_FILTER, searchControls);
            while (results.hasMore()) {
                Attributes attrs;
                Attribute memberOfAttr;
                SearchResult result = results.next();
                if (!result.getNameInNamespace().equals(groupDn) || (memberOfAttr = (attrs = result.getAttributes()).get("memberOf")) == null) continue;
                NamingEnumeration<?> e = memberOfAttr.getAll();
                while (e.hasMore()) {
                    String nestedGroupDn = (String)e.next();
                    if (!allGroups.add(nestedGroupDn)) continue;
                    this.findNestedGroupsBasedOn(ctx, nestedGroupDn, allGroups);
                }
            }
        }
        catch (NamingException e) {
            log.error("Error while finding nested groups: " + e.getMessage());
        }
    }

    public String createBindPrincipal(String login, String userDNPattern) {
        if (Objects.nonNull(userDNPattern) && !userDNPattern.isEmpty()) {
            return userDNPattern.replace("{0}", login);
        }
        return login;
    }

    private SSLContext getSSLContext(String cert) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        if (Objects.nonNull(cert)) {
            try (ByteArrayInputStream certIn = new ByteArrayInputStream(cert.getBytes());){
                keyStore.setCertificateEntry("ldap", CertificateFactory.getInstance("X.509").generateCertificate(certIn));
            }
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, null);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private SearchControls getSearchControls(String[] attrIDs) {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(attrIDs);
        searchControls.setSearchScope(2);
        return searchControls;
    }
}

