/*
 * Decompiled with CFR 0.152.
 */
package io.softwarity.lib.ldap;

import io.softwarity.lib.ldap.LdapConfiguration;
import io.softwarity.lib.ldap.LdapResult;
import io.softwarity.lib.ldap.LdapSSLSocketFactory;
import io.softwarity.lib.ldap.LdapSearch;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class LdapService {
    private static final Logger log = LoggerFactory.getLogger(LdapService.class);
    private final LdapSearch ldapSearch = new LdapSearch();

    public <T> Mono<T> getLdapUser(LdapConfiguration ldapConf, String login, String password, BiFunction<String, LdapResult, T> ldapUserSupplier) {
        log.debug("getLdapUser: {}", (Object)login);
        return this.getLdapResult(ldapConf, login, password).map(ldapResult -> ldapUserSupplier.apply(login, (LdapResult)ldapResult));
    }

    public Mono<LdapResult> getLdapResult(LdapConfiguration ldapConf, String login, String password) {
        log.debug("getLdapResult: {}", (Object)login);
        return this.search(ldapConf, login, password);
    }

    private Mono<LdapResult> search(LdapConfiguration ldapConf, String login, String password) {
        return Mono.create(sink -> {
            String searchUser = login;
            String w = password;
            String url = ldapConf.getUri();
            String b = ldapConf.getBaseDN();
            boolean zz = ldapConf.isZz();
            String filter = ldapConf.getFilter();
            String userDnPattern = ldapConf.getBindDN();
            String cert = ldapConf.getCert();
            boolean ignoreCertHostname = ldapConf.isIgnoreCertHostname();
            String D = this.ldapSearch.createBindPrincipal(searchUser, userDnPattern);
            InitialLdapContext context = null;
            StartTlsResponse tls = null;
            try {
                context = this.ldapSearch.initContext(url);
                if (zz) {
                    tls = this.ldapSearch.addZZOption(context, cert, ignoreCertHostname);
                }
                if (url.toLowerCase().startsWith("ldaps")) {
                    LdapSSLSocketFactory.addCert("ldap", cert);
                    context.addToEnvironment("java.naming.ldap.factory.socket", LdapSSLSocketFactory.class.getName());
                }
                this.ldapSearch.connect(context, D, w);
                sink.success((Object)this.ldapSearch.search(context, D, b, filter, login));
                this.closeObject(tls);
                this.closeObject(context);
            }
            catch (Throwable e) {
                try {
                    sink.error(e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.closeObject(tls);
                    this.closeObject(context);
                }
            }
        });
    }

    private void closeObject(Object o) {
        if (Objects.isNull(o)) {
            return;
        }
        try {
            o.getClass().getMethod("close", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

